/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.impl.signature.local.smime;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.MultipleSignatureExecutionData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Node;

public class ParallelDettachedSmimeExecution
extends SignatureExecution {
    private static final long serialVersionUID = 1L;
    private int validSignatures;
    private int invalidSignatures;
    private int signersLength = 0;

    public ParallelDettachedSmimeExecution(String name, String Description) {
        super(name, Description);
    }

    protected void executeSignature(Map globalVariables) throws Throwable {
        InputStream ins = null;
        String inputURL = DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)this.getData()).getFileToSignURL(), globalVariables);
        this.signersLength = ((MultipleSignatureExecutionData)this.getData()).getSignersLength();
        Signature[] s = new Signature[this.signersLength];
        for (int i = 0; i < this.signersLength; ++i) {
            ins = new URL(inputURL).openStream();
            s[i] = this.getSigner().sign(ins, DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)this.getData()).getCertName(i), globalVariables), DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)this.getData()).getPassword(i), globalVariables), DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)this.getData()).getContentType(i), globalVariables));
            try {
                ins.close();
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        ins = new URL(inputURL).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getSigner().generateSMIMEParalell(ins, s, (OutputStream)out);
        this.setResult(out.toByteArray());
        try {
            ins.close();
            out.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public int verify(Map globalVariables) {
        String s = null;
        if (this.getResult() != null) {
            try {
                s = (String)this.getResult();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 0;
            }
            try {
                SMIMEParser parser = this.getSigner().getSMIMEParser((InputStream)new ByteArrayInputStream((byte[])this.getResult()));
                Signature[] vs = parser.getSignatures();
                for (int i = 0; i < vs.length; ++i) {
                    ByteArrayInputStream vis = new ByteArrayInputStream((byte[])parser.getSignedObject());
                    if (vs[i].verify((InputStream)vis)) {
                        ++this.validSignatures;
                        continue;
                    }
                    ++this.invalidSignatures;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 0;
            }
            if (this.validSignatures == this.signersLength && this.invalidSignatures == 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        MultipleSignatureExecutionData d = new MultipleSignatureExecutionData();
        d.parseData(executionDirector, item);
        return d;
    }
}

