/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.views;

import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.core.ExecutionView;
import es.caib.signatura.test.core.RemoteExecutionVerificationRequest;
import es.caib.signatura.test.core.StatusChangeEventListener;
import es.caib.signatura.test.core.SynchronizableBoolean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TestApplet
extends JApplet
implements ActionListener,
ExecutionView,
StatusChangeEventListener {
    private ExecutionDirector director = new ExecutionDirector();
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanelCenter = null;
    private JLabel jLabelTitle = null;
    private SynchronizableBoolean userInputLock = new SynchronizableBoolean(true);
    private Vector executions = new Vector();
    private Vector checkboxes = new Vector();
    private Vector executionPanels = new Vector();
    private String requestedAction;
    private JPanel jPanelBottom = null;
    private JButton jButtonBegin = null;
    private JButton jButtonShowResults = null;
    private JButton jButtonExportResults = null;
    private String monitorServletURL;
    private String configFilePath;
    private boolean configured = false;

    public void init() {
        this.setSize(500, 500);
        this.setPreferredSize(new Dimension(500, 500));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelTitle = new JLabel();
            this.jLabelTitle.setText("Applet de verificaci\u00f3 de funcionalitats");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(400, 400));
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.jLabelTitle, "North");
            this.jContentPane.add((Component)this.getJPanelBottom(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJPanelCenter());
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.jScrollPane;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            this.jPanelCenter = new JPanel();
            this.jPanelCenter.setLayout(new BoxLayout(this.jPanelCenter, 1));
        }
        return this.jPanelCenter;
    }

    private JPanel getJPanelFunc1(String name, boolean active) {
        JLabel jLabelFunc1Title = new JLabel();
        jLabelFunc1Title.setText(name);
        JPanel jPanelFunc1 = new JPanel();
        jPanelFunc1.setLayout(new BoxLayout(jPanelFunc1, 0));
        jPanelFunc1.add((Component)jLabelFunc1Title, null);
        JCheckBox check = this.getJCheckBoxFunc1Active(active);
        jPanelFunc1.add((Component)check, null);
        this.checkboxes.add(check);
        this.executionPanels.add(jPanelFunc1);
        return jPanelFunc1;
    }

    private JCheckBox getJCheckBoxFunc1Active(boolean active) {
        JCheckBox jCheckBoxFunc1Active = new JCheckBox();
        jCheckBoxFunc1Active.setSelected(active);
        return jCheckBoxFunc1Active;
    }

    public void start() {
        super.start();
        this.configFilePath = this.getParameter("config");
        this.monitorServletURL = this.getParameter("export");
        this.director.setView(this);
        this.director.setMonitorServletURL(this.monitorServletURL);
        this.director.setConfigURL(this.configFilePath);
        this.director.start();
    }

    public void closeView() {
    }

    public void notifyFatal(String message, Exception e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(null, message, "Error", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryActions() {
        if (this.configured) {
            this.configured = false;
        } else {
            SynchronizableBoolean synchronizableBoolean = this.userInputLock;
            synchronized (synchronizableBoolean) {
                while (this.userInputLock.get()) {
                    try {
                        this.userInputLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.userInputLock.set(true);
            }
        }
        this.enableUserActions(false);
        return this.requestedAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector queryUserExecutionsConfig() {
        SynchronizableBoolean synchronizableBoolean = this.userInputLock;
        synchronized (synchronizableBoolean) {
            while (this.userInputLock.get()) {
                try {
                    this.userInputLock.wait();
                }
                catch (InterruptedException e) {}
            }
            this.userInputLock.set(true);
        }
        int i = 0;
        Iterator it = this.executions.iterator();
        while (it.hasNext()) {
            Execution ex = (Execution)it.next();
            JCheckBox check = (JCheckBox)this.checkboxes.get(i);
            ex.setActive(check.isSelected());
            List statusChangeListeners = ex.getStatusChangeListeners();
            statusChangeListeners.add(this);
            ex.setStatusChangeListeners(statusChangeListeners);
            ++i;
        }
        this.configured = true;
        this.enableUserActions(true);
        return this.executions;
    }

    public void showAvailableExecutions(Vector executions) {
        this.executions = executions;
        Iterator it = executions.iterator();
        while (it.hasNext()) {
            Execution ex = (Execution)it.next();
            this.getJPanelCenter().add(this.getJPanelFunc1(ex.getName(), ex.isActive()));
        }
        this.validate();
    }

    public void updateResults(Vector executions) {
        this.executions = executions;
        Iterator it = executions.iterator();
        int i = 0;
        while (it.hasNext()) {
            Execution ex = (Execution)it.next();
            if (ex.isActive()) {
                JLabel resultLabel;
                JPanel panel = (JPanel)this.executionPanels.get(i);
                int result = ex.getVerificationResult();
                if (result == 1) {
                    resultLabel = new JLabel(new ImageIcon(this.getClass().getResource("ok.gif")));
                    panel.add(resultLabel);
                } else if (result == 0) {
                    resultLabel = new JLabel(new ImageIcon(this.getClass().getResource("ko.gif")));
                    panel.add(resultLabel);
                } else {
                    resultLabel = new JLabel(new ImageIcon(this.getClass().getResource("manual.gif")));
                    panel.add(resultLabel);
                }
            }
            ++i;
        }
        this.enableUserActions(true);
        this.validate();
    }

    private JPanel getJPanelBottom() {
        if (this.jPanelBottom == null) {
            this.jPanelBottom = new JPanel();
            this.jPanelBottom.setLayout(new FlowLayout());
            this.jPanelBottom.add((Component)this.getJButtonBegin(), null);
            this.jPanelBottom.add((Component)this.getJButtonShowResults(), null);
            this.jPanelBottom.add((Component)this.getJButtonExportResults(), null);
        }
        return this.jPanelBottom;
    }

    private JButton getJButtonBegin() {
        if (this.jButtonBegin == null) {
            this.jButtonBegin = new JButton();
            this.jButtonBegin.setText("Start");
            this.jButtonBegin.setActionCommand("start-executions");
            this.jButtonBegin.addActionListener(this);
        }
        return this.jButtonBegin;
    }

    private JButton getJButtonShowResults() {
        if (this.jButtonShowResults == null) {
            this.jButtonShowResults = new JButton();
            this.jButtonShowResults.setText("Show results");
            this.jButtonShowResults.setActionCommand("show-results");
            this.jButtonShowResults.addActionListener(this);
        }
        return this.jButtonShowResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        this.enableUserActions(false);
        this.requestedAction = e.getActionCommand();
        SynchronizableBoolean synchronizableBoolean = this.userInputLock;
        synchronized (synchronizableBoolean) {
            this.userInputLock.set(false);
            this.userInputLock.notifyAll();
        }
    }

    private JButton getJButtonExportResults() {
        if (this.jButtonExportResults == null) {
            this.jButtonExportResults = new JButton();
            this.jButtonExportResults.setText("Export results");
            this.jButtonExportResults.setActionCommand("export-results");
            this.jButtonExportResults.addActionListener(this);
        }
        return this.jButtonExportResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportResults(String export) {
        String pluginVersion = System.getProperty("javaplugin.version");
        String agentVersion = System.getProperty("http.agent");
        String export1 = export.substring(0, export.indexOf(10) + 1).replaceFirst("([^\n]*)\n", "Navegador|Plugin|$1\n");
        String export2 = export.substring(export.indexOf(10) + 1, export.length()).replaceAll("([^\n]*)\n", agentVersion + "|" + pluginVersion + "|$1\n");
        String extendedExport = export1 + export2;
        if (this.monitorServletURL != null) {
            try {
                this.enableUserActions(false);
                URL url = new URL(this.monitorServletURL);
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                c.addRequestProperty("configFilePath", this.configFilePath);
                c.setDoInput(true);
                c.setDoOutput(true);
                c.setRequestMethod("GET");
                c.connect();
                OutputStream o = c.getOutputStream();
                o.write(extendedExport.getBytes());
                o.close();
                String response = this.readInputStream(c.getInputStream());
                System.out.println(response);
                c.disconnect();
            }
            catch (Exception e) {
                this.notifyFatal(e.getMessage(), e);
                e.printStackTrace();
            }
            finally {
                this.enableUserActions(true);
            }
        } else {
            JTextArea area = new JTextArea();
            area.setText(extendedExport);
            this.getJPanelCenter().add(area);
            this.validate();
        }
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(inputStream);
        byte[] b = new byte[8192];
        int read = 0;
        while ((read = in.read(b)) > 0) {
            out.write(b, 0, read);
        }
        in.close();
        return out.toString("UTF-8");
    }

    private void enableUserActions(boolean b) {
        this.getJButtonBegin().setEnabled(b);
        this.getJButtonExportResults().setEnabled(b);
        this.getJButtonShowResults().setEnabled(b);
    }

    public void onFinalizeExecutions() {
        this.enableUserActions(true);
    }

    public void executionStatusUpdated(Execution source, Map globalVariables, int oldStatus, int newStatus) {
        if (oldStatus == 2 && newStatus == 3) {
            JPanel panel = null;
            int i = 0;
            while (!((JLabel)(panel = (JPanel)this.executionPanels.get(i)).getComponent(0)).getText().equals(source.getName())) {
                ++i;
            }
            int result = 0;
            if (source.getVerificationResult() == null) {
                result = source.verify(globalVariables);
                source.setVerificationResult(new Integer(result));
            } else {
                result = source.getVerificationResult();
            }
            if (result == -2) {
                try {
                    result = this.executeRemoteVerification(source, globalVariables);
                    source.setVerificationResult(new Integer(result));
                }
                catch (Exception e) {
                    this.notifyFatal(e.getMessage(), e);
                }
            }
            if (result == 1) {
                JLabel resultLabel = new JLabel(new ImageIcon(this.getClass().getResource("ok.gif")));
                panel.add(resultLabel);
            } else if (result == 0) {
                JLabel resultLabel = new JLabel(new ImageIcon(this.getClass().getResource("ko.gif")));
                panel.add(resultLabel);
            } else if (result == -1) {
                JLabel resultLabel = new JLabel(new ImageIcon(this.getClass().getResource("manual.gif")));
                panel.add(resultLabel);
            }
            this.validate();
        }
    }

    private int executeRemoteVerification(Execution ex, Map globalVariables) throws Exception {
        String remoteVerificationServlet = this.monitorServletURL.replace("ResultsCollectorServlet", "RemoteVerificationServlet");
        URL uploadServletURL = new URL(remoteVerificationServlet);
        RemoteExecutionVerificationRequest verificationReq = new RemoteExecutionVerificationRequest(ex, globalVariables);
        HttpURLConnection c = (HttpURLConnection)uploadServletURL.openConnection();
        c.setDoInput(true);
        c.setDoOutput(true);
        c.setRequestMethod("POST");
        c.connect();
        ObjectOutputStream o = new ObjectOutputStream(c.getOutputStream());
        o.writeObject(verificationReq);
        o.flush();
        o.close();
        String response = this.readInputStream(c.getInputStream());
        c.disconnect();
        if (c.getResponseCode() != 200) {
            return 0;
        }
        return Integer.parseInt(response);
    }
}

