package es.caib.signatura.test.core;


import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.util.Hashtable;





public class ContentTypeRegistry { 
	private final String configFile="mimes.csv";
	
	private Hashtable extensionsTable=new Hashtable();
	private Hashtable contentTypesTable=new Hashtable();
	
	public ContentTypeRegistry() throws IOException {
		InputStream is=null;
		try{
			is=getClass().getClassLoader().getResourceAsStream(configFile);

			StreamTokenizer st=new StreamTokenizer(is);
			st.resetSyntax();
			st.wordChars(33, 255);
			st.whitespaceChars(0,32);
			st.eolIsSignificant (true);  
			
			
			do{
				int i=0;
				Object [] arr=new Object[2];
				do{
					st.nextToken();
					if(i<2){ //sabemos que s�lo debe tener dos columnas
						
	
						if(st.ttype==st.TT_NUMBER)
							arr[i]=new Double(st.nval);
						else
							arr[i]=st.sval;
	
						i++;
					}
				}while(st.ttype!=st.TT_EOL && st.ttype!=st.TT_EOF);
				if(arr[0]!=null){ //salto de linea al final del fichero
					extensionsTable.put(arr[0],arr[1]);
					contentTypesTable.put(arr[1],arr[0]);
				}
			}while(st.ttype!=st.TT_EOF);
		}catch(IOException e){
			throw e;
		}finally{
			if(is!=null)try{is.close();}catch(Exception ie){ 
				ie.printStackTrace();
			}
		}
	}

	public String getContentTypeByExtension(String extension){
		return (String)extensionsTable.get(extension.toLowerCase());
	}
	
	public String getExtensionByContentType(String contentType){
		return (String)contentTypesTable.get(contentType);
	}
}
