package es.caib.signatura.test.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.test.impl.signature.data.SignatureExecutionData;

public abstract class Execution implements Serializable{

		/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
		private String name=null;
		private String description=null;
		private ExecutionData data=null;
		private boolean active=true;
		private Object result=null;
		private String resultContentType=null;
		private Integer verificationResult=null;
		private SynchronizableInt status=new SynchronizableInt(0);
		transient private List statusChangeListeners=new ArrayList();
		transient private ByteArrayOutputStream outStreamBytes=new ByteArrayOutputStream();
		transient private ByteArrayOutputStream errStreamBytes=new ByteArrayOutputStream();
		transient private PrintStream outStream=new PrintStream(outStreamBytes);
		transient private PrintStream errStream=new PrintStream(outStreamBytes);
		
		public static final int STATUS_CREATED=0;
		public static final int STATUS_CONFIGURED=1;
		public static final int STATUS_RUNNING=2;
		public static final int STATUS_DONE=3;
		
		public static final int VERIFICATION_KO = 0;
		public static final int VERIFICATION_OK = 1;
		public static final int VERIFICATION_MANUAL = -1;
		public static final int VERIFICATION_REMOTE = -2;
		
		public Execution(String name,String Description) {
			this.name=name;
			this.description=description;
		}
		
		public abstract void execute(Map globalVariables);

		public abstract int verify(Map globalVariables);
		
		public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException{
			ExecutionData d=new ExecutionData();
			d.parseData(executionDirector, item);
			return d;
		}
		
		/**
		 * @return the name
		 */
		public synchronized String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public synchronized void setName(String name) {
			this.name = name;
		}


		/**
		 * @return the description
		 */
		public synchronized String getDescription() {
			return description;
		}


		/**
		 * @param description the description to set
		 */
		public synchronized void setDescription(String description) {
			this.description = description;
		}


		/**
		 * @return the data
		 */
		public synchronized ExecutionData getData() {
			return data;
		}


		/**
		 * @param data the data to set
		 */
		public synchronized void setData(ExecutionData data) {
			this.data = data;
		}


		/**
		 * @return the active
		 */
		public synchronized boolean isActive() {
			return active;
		}


		/**
		 * @param active the active to set
		 */
		public synchronized void setActive(boolean active) {
			this.active = active;
		}


		/**
		 * @return the result
		 */
		public synchronized Object getResult() {
			return result;
		}


		/**
		 * @param result the result to set
		 */
		public synchronized void setResult(Object result) {
			this.result = result;
		}


		
		/**
		 * @return the status
		 */
		public synchronized int getStatus() {
			return status.get();
		}

		/**
		 * @return the statusChangeListeners
		 */
		public synchronized List getStatusChangeListeners() {
			return statusChangeListeners;
		}

		/**
		 * @param statusChangeListeners the statusChangeListeners to set
		 */
		public synchronized void setStatusChangeListeners(List statusChangeListeners) {
			this.statusChangeListeners = statusChangeListeners;
		}

		public void addStatusChangeEventListener(StatusChangeEventListener listener){
			getStatusChangeListeners().add(listener);
		}
		protected void setStatus(int status,Map globalVariables){
			int oldStatus=getStatus();
			this.status.set(status);
			
			Iterator it=getStatusChangeListeners().iterator();
			while(it.hasNext()){
				((StatusChangeEventListener)it.next()).executionStatusUpdated(this,globalVariables,oldStatus, status);
			}
			
		}

		public synchronized PrintStream getOut() {
			return outStream;
		}

		public synchronized PrintStream getErr() {
			return errStream;
		}
		
		public synchronized ByteArrayOutputStream getOutStreamBytes() {
			return outStreamBytes;
		}
		
		public synchronized ByteArrayOutputStream getErrStreamBytes() {
			return errStreamBytes;
		}

		/**
		 * @return the verificationResult
		 */
		public synchronized Integer getVerificationResult() {
			return verificationResult;
		}

		/**
		 * @param verificationResult the verificationResult to set
		 */
		public synchronized void setVerificationResult(Integer verificationResult) {
			this.verificationResult = verificationResult;
		}

		/**
		 * @return the resultContentType
		 */
		public synchronized String getResultContentType() {
			return resultContentType;
		}

		/**
		 * @param resultContentType the resultContentType to set
		 */
		public synchronized void setResultContentType(String resultContentType) {
			this.resultContentType = resultContentType;
		}
		
		
		
		
}
