package es.caib.signatura.test.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;



public class Pipe {

	private class SynchronizableBoolean{
		boolean bool=true;
		SynchronizableBoolean(boolean value){
			this.bool=value;
		}
		
		public boolean get(){
			return this.bool;
		}
		
		public void set(boolean value){
			this.bool=value;
		}
		
		
	}
	
	InputStream in=null;
	OutputStream out=null;
	String name=null;
	SynchronizableBoolean lock=new SynchronizableBoolean(true);
	
	public Pipe(String p_name,InputStream inputStream, OutputStream outputStream) {
		in= inputStream;
		out= outputStream;
		name=p_name;
		
	}
	
	public  void run(){		
		int in_char=-1;
		BufferedReader r = new BufferedReader(new InputStreamReader(in));
		BufferedWriter p=new BufferedWriter(new OutputStreamWriter(out));
		do{
			String s=null;
			try {
					//asíncron
	             	if(r.ready()){
	             		s = r.readLine();
	                     if (s == null) {
	                         break;
	                     }

					}else{
						//timeout
						
						synchronized (lock) {
							try {
								if(lock.get())
									lock.wait(500);
								else
									break;
							} catch (InterruptedException e) {
							}
						}
						
					}
				} catch (IOException e) {
					e.printStackTrace();
					break;
				}
			try {
					if(s!=null){
						p.write(s);
						p.flush();
					}
				} catch (IOException e1) {
					break;
				}
				
			
		}while(true);
		
	}		
	
	
	public void unpipe(){
		synchronized (lock) {
			lock.set(false);
			lock.notifyAll();
		}
	}
/**
	public static void main(String[] args) {
		BufferedInputStream in=(BufferedInputStream)System.in;
		System.out.println("AIXO ES UNA PROVA I HAURIA DE FUNCIONAR");
		int in_char=-1;
		do{
			try {
				in_char=in.read();
			} catch (IOException e) {
				e.printStackTrace();
				break;
			}
			System.out.print("->"+(char)in_char);
			
		}while(in_char!=-1);
	}
**/
}
