package es.caib.signatura.test.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;





public class ProcessHelper{
	private Process proc=null;
	private OutputStream out=System.out;
	private InputStream in=System.in;
	private OutputStream err=System.err;

	private RedirectorThread t1;
	private RedirectorThread t2;
	private RedirectorThread t3;
	
	private class RedirectorThread extends Thread{
		private Process proc=null;
		private String debug_name;
		private InputStream inputStream;
		private OutputStream outputStream;
		private Pipe p;
		
		public RedirectorThread(Process p_proc,String p_debug_name,InputStream p_inputStream, OutputStream p_outputStream){
			proc=p_proc;
			debug_name=p_debug_name;
			inputStream=p_inputStream;
			outputStream=p_outputStream;
			
		}

		public void run(){
			p=new Pipe(debug_name, inputStream, outputStream);		
			p.run();
		}
		public void unpipe(){
			p.unpipe();
		}
		public InputStream getInputStream() {
			return inputStream;
		}

		public void setInputStream(InputStream inputStream) {
			this.inputStream = inputStream;
		}

		public String getDebugName() {
			return debug_name;
		}

		public void setDebugName(String name) {
			this.debug_name = name;
		}

		public OutputStream getOutputStream() {
			return outputStream;
		}

		public void setOutputStream(OutputStream outputStream) {
			this.outputStream = outputStream;
		}

		public Process getProc() {
			return proc;
		}

		public void setProc(Process proc) {
			this.proc = proc;
		}
	
	}
	
	public ProcessHelper(){
	}
	
	private synchronized int redirectAndWait(){
		t1=new RedirectorThread(proc,"out",proc.getInputStream(),out);

		t2=new RedirectorThread(proc,"in",in,proc.getOutputStream());
		
		t3=new RedirectorThread(proc,"err",proc.getErrorStream(),err);
		
		int ret=-1;
		try {
			t3.start();
			t2.start();
			t1.start();
			ret=proc.waitFor();
			t1.unpipe();
			t2.unpipe();
			t3.unpipe();
			t1.stop(); t1=null;
			t2.stop(); t2=null;
			t3.stop(); t3=null;
		} catch (InterruptedException e) {

			e.printStackTrace();
		}
		return ret;
	}
	
	public synchronized int runAndWait(String [] command){
		Runtime run=Runtime.getRuntime();
		
		try {
			proc=run.exec(command);
			
		} catch (IOException e) {
			e.printStackTrace();
			return -1;
		
		}

		return redirectAndWait();
	}
	
	public synchronized int runAndWait(String [] command,String [] environment){
		Runtime run=Runtime.getRuntime();
		
		try {
			proc=run.exec(command,environment);
			
		} catch (IOException e) {
			e.printStackTrace();
			return -1;
		
		}
		
		return redirectAndWait();
	}


	public InputStream getIn() {
		return in;
	}

	public void setIn(InputStream in) {
		this.in = in;
	}

	public OutputStream getOut() {
		return out;
	}

	public void setOut(OutputStream out) {
		this.out = out;
	}

	public Process getProc() {
		return proc;
	}

	public void setProc(Process proc) {
		this.proc = proc;
	}

	public OutputStream getErr() {
		return err;
	}

	public void setErr(OutputStream err) {
		this.err = err;
	}

}
