package es.caib.signatura.test.impl.signature;

import java.io.ByteArrayInputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;

import org.w3c.dom.Node;

import es.caib.signatura.api.Signer;
import es.caib.signatura.api.SignerFactory;
import es.caib.signatura.api.UpgradeNeededException;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.data.SignatureExecutionData;
import es.caib.signatura.test.privileged.utils.SignatureTestUtils;

public abstract class SignatureExecution extends Execution{
	private static final long serialVersionUID = 1L;
	transient private Signer signer;

	public SignatureExecution(String name, String Description) {
		super(name, Description);
	}

	public final void execute(Map globalVariables){	
		try{
   			//establim els providers actuals
			String unactive=DynamicQueryResolver.resolveString(((SignatureExecutionData)getData()).getUnactiveProviders(),globalVariables);
   		   	System.out.println("######################");
   		   	System.out.println("Execution: "+getName());
   			if(unactive!=null)
				SignatureTestUtils.setUnactiveProviders(unactive);

   			//inicialitzem el signer amb les propietats passades a la configuració, o amb les que té per defecte
   			String str_properties=DynamicQueryResolver.resolveString(((SignatureExecutionData)getData()).getProperties(),globalVariables);
   			Properties api_properties=null;
   			if(str_properties!=null && !"".equals(str_properties)){
   				api_properties=new Properties();
   				api_properties.load(new ByteArrayInputStream(str_properties.getBytes()));
   			}
   			signer = new SignerFactory(api_properties).getSigner();

   			//invoquem el metode abstracte de firma
			executeSignature(globalVariables);
			SignatureTestUtils.setUnactiveProviders("");
		

			
		}catch(Throwable t){
			t.printStackTrace();
			setResult(t);
		}
	}

	/**
	 * Ejecución de las firmas
	 * @param globalVariables 
	 */
	protected abstract void executeSignature(Map globalVariables) throws Throwable;

	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		SignatureExecutionData d=new SignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}

	/**
	 * @return the signer
	 */
	public synchronized Signer getSigner() {
		return signer;
	}
	
	

}
