package es.caib.signatura.test.impl.signature;

import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.Signer;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.data.WSClientConfigurationExecutionData;
import es.caib.signatura.test.privileged.utils.SignatureTestUtils;

public abstract class WSClientConfigurationExecution extends Execution{
	private static final long serialVersionUID = 1L;

	private Signer signer;

	public WSClientConfigurationExecution(String name, String Description) {
		super(name, Description);
	}

	public void execute(Map globalVariables){	
		try{
			//establim els paràmetres del WS
			SignatureTestUtils.setSignatureWebserviceParams(
   					DynamicQueryResolver.resolveString(((WSClientConfigurationExecutionData)getData()).getWSUsername(),globalVariables)
   					,DynamicQueryResolver.resolveString(((WSClientConfigurationExecutionData)getData()).getWSPassword(),globalVariables)
   					,DynamicQueryResolver.resolveString(((WSClientConfigurationExecutionData)getData()).getWSEndpoint(),globalVariables)
   					);
 		}catch(Throwable t){
			t.printStackTrace();
			setResult(t);
		}
	}

	/**
	 * Ejecución de las firmas
	 * @param globalVariables 
	 */
	protected abstract void executeSignature(Map globalVariables) throws Throwable;

	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		WSClientConfigurationExecutionData d=new WSClientConfigurationExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}

	
	

}
