/**
 * 
 */
package es.caib.signatura.test.impl.signature.data;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Node;

import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;

/**
 * @author e43155798r
 *
 */
public class CertifyDigitalCopyExecutionData extends SingleSignatureExecutionData {
	
	private String stampURL = "";
	private String localidad = "";
	private String stampPositionX = "0";
	private String stampPositionY = "0";
	private String stampRotation = "0";
	
	public void parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		super.parseData(executionDirector, item);
		try{
			// Inicializar los objetos para las busquedas de elementos en el xml
	        XPathFactory factory = XPathFactory.newInstance();
	        XPath xpath = factory.newXPath();
	        	        
	        //PDF
	        setStampURL((String)xpath.evaluate("./stampURL",item,XPathConstants.STRING));
	        setLocalidad((String)xpath.evaluate("./localidad",item,XPathConstants.STRING));
	        setStampPositionX((String)xpath.evaluate("./stampPositionX",item,XPathConstants.STRING));
	        setStampPositionY((String)xpath.evaluate("./stampPositionY",item,XPathConstants.STRING));
	        setStampRotation((String)xpath.evaluate("./stampRotation",item,XPathConstants.STRING));
	        
		}catch(Throwable t){
			throw new ExecutionDataParseException(t.getMessage(), t);
		}
		
	}

	/**
	 * @return the stampURL
	 */
	public synchronized String getStampURL() {
		return stampURL;
	}

	/**
	 * @param stampURL the stampURL to set
	 */
	public synchronized void setStampURL(String stampURL) {
		this.stampURL = stampURL;
	}

	/**
	 * @return the localidad
	 */
	public synchronized String getLocalidad() {
		return localidad;
	}

	/**
	 * @param localidad the localidad to set
	 */
	public synchronized void setLocalidad(String localidad) {
		this.localidad = localidad;
	}

	/**
	 * @return the stampPositionX
	 */
	public synchronized String getStampPositionX() {
		return stampPositionX;
	}

	/**
	 * @param stampPositionX the stampPositionX to set
	 */
	public synchronized void setStampPositionX(String stampPositionX) {
		this.stampPositionX = stampPositionX;
	}

	/**
	 * @return the stampPositionY
	 */
	public synchronized String getStampPositionY() {
		return stampPositionY;
	}

	/**
	 * @param stampPositionY the stampPositionY to set
	 */
	public synchronized void setStampPositionY(String stampPositionY) {
		this.stampPositionY = stampPositionY;
	}

	/**
	 * @return the stampRotation
	 */
	public synchronized String getStampRotation() {
		return stampRotation;
	}

	/**
	 * @param stampRotation the stampRotation to set
	 */
	public synchronized void setStampRotation(String stampRotation) {
		this.stampRotation = stampRotation;
	}

}
