package es.caib.signatura.test.impl.signature.data;

import java.net.URL;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;


public class MultipleSignatureExecutionData extends SignatureExecutionData {
	private String unactiveProviders="";
	private String fileToSignURL;
	
	private String [] certName=null;
	private String [] password=null;
	private String [] contentType=null;
	
	
	
	public void parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		try{
			// Inicializar los objetos para las busquedas de elementos en el xml
	        XPathFactory factory = XPathFactory.newInstance();
	        XPath xpath = factory.newXPath();
	        
	        
	        // Extraer la información del xml xpath.evaluate(".",originalConfig2,XPathConstants.NODE)
	        setUnactiveProviders((String)xpath.evaluate("./unactiveproviders",item,XPathConstants.STRING));
	        setFileToSignURL((String)xpath.evaluate("./filetosignurl",item,XPathConstants.STRING));
	        
	        //extraer informacion de los firmantes
	        NodeList signers=(NodeList)xpath.evaluate("./signer",item,XPathConstants.NODESET);
	        
	        certName=new String[signers.getLength()];
	        password=new String[signers.getLength()];
	        contentType=new String[signers.getLength()];
	        
	        for(int i=1;i<=signers.getLength();i++){
	        	parseSigners(i-1,(Node)xpath.evaluate("./signer["+i+"]",item,XPathConstants.NODE));
			}
		}catch(Throwable t){
			throw new ExecutionDataParseException(t.getMessage(), t);
		}
		
	}


	private void parseSigners(int i,Node item) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        
		setCertName(i,(String)xpath.evaluate("./certname",item,XPathConstants.STRING));
        setPassword(i,(String)xpath.evaluate("./password",item,XPathConstants.STRING));
        setContentType(i,(String)xpath.evaluate("./contenttype",item,XPathConstants.STRING));

		
	}


	/**
	 * @return the unactiveProviders
	 */
	public synchronized String getUnactiveProviders() {
		return unactiveProviders;
	}


	/**
	 * @param unactiveProviders the unactiveProviders to set
	 */
	public synchronized void setUnactiveProviders(String unactiveProviders) {
		this.unactiveProviders = unactiveProviders;
	}


	/**
	 * @return the certName
	 */
	public synchronized String getCertName(int index) {
		return certName[index];
	}


	/**
	 * @param certName the certName to set
	 */
	public synchronized void setCertName(int index,String certName) {
		this.certName[index] = certName;
	}


	/**
	 * @return the pasword
	 */
	public synchronized String getPassword(int index) {
		return password[index];
	}


	/**
	 * @param pasword the pasword to set
	 */
	public synchronized void setPassword(int index,String password) {
		this.password[index] = password;
	}


	/**
	 * @return the fileToSignURL
	 */
	public synchronized String getFileToSignURL() {
		return fileToSignURL;
	}


	/**
	 * @param fileToSignURL the fileToSignURL to set
	 */
	public synchronized void setFileToSignURL(String fileToSignURL) {
		this.fileToSignURL = fileToSignURL;
	}


	/**
	 * @return the contentType
	 */
	public synchronized String getContentType(int index) {
		return contentType[index];
	}


	/**
	 * @param contentType the contentType to set
	 */
	public synchronized void setContentType(int index,String contentType) {
		this.contentType[index] = contentType;
	}


	public synchronized int getSignersLength(){
		return this.certName.length;
	}


}
