package es.caib.signatura.test.impl.signature.data;

import java.net.URL;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Node;

import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;


public class PDFSingleSignatureExecutionData extends SingleSignatureExecutionData {
	private String stampPosition="0";
	private String stampURL="";
	private String allowMultipleSignature="false";
	private String checkPAdESBES="";
	private String x=null;
	private String y=null;
	private String height=null;
	private String width=null;
	private String rotation=null;
	
	public void parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		super.parseData(executionDirector, item);
		try{
			// Inicializar los objetos para las busquedas de elementos en el xml
	        XPathFactory factory = XPathFactory.newInstance();
	        XPath xpath = factory.newXPath();
	        
	        
	        
	        //PDF
	        setStampPosition((String)xpath.evaluate("./stampPosition",item,XPathConstants.STRING));
	        setStampURL((String)xpath.evaluate("./stampURL",item,XPathConstants.STRING));
	        setAllowMultipleSignature(((String)xpath.evaluate("./allowMultipleSignature",item,XPathConstants.STRING)));
	        setCheckPAdESBES((String)xpath.evaluate("./checkpadesbes",item,XPathConstants.STRING));
	        setX((String)xpath.evaluate("./x",item,XPathConstants.STRING));
	        setY((String)xpath.evaluate("./y",item,XPathConstants.STRING));
	        setHeight((String)xpath.evaluate("./height",item,XPathConstants.STRING));
	        setWidth((String)xpath.evaluate("./width",item,XPathConstants.STRING));
	        setRotation((String)xpath.evaluate("./rotation",item,XPathConstants.STRING));
		}catch(Throwable t){
			throw new ExecutionDataParseException(t.getMessage(), t);
		}
		
	}





	/**
	 * @return the stampPosition
	 */
	public synchronized String getStampPosition() {
		return stampPosition;
	}


	/**
	 * @param stampPosition the stampPosition to set
	 */
	public synchronized void setStampPosition(String stampPosition) {
		this.stampPosition = stampPosition;
	}


	/**
	 * @return the stampURL
	 */
	public synchronized String getStampURL() {
		return stampURL;
	}


	/**
	 * @param stampURL the stampURL to set
	 */
	public synchronized void setStampURL(String stampURL) {
		this.stampURL = stampURL;
	}


	/**
	 * @return the allowMultipleSignature
	 */
	public synchronized String isAllowMultipleSignature() {
		return allowMultipleSignature;
	}


	/**
	 * @param allowMultipleSignature the allowMultipleSignature to set
	 */
	public synchronized void setAllowMultipleSignature(String allowMultipleSignature) {
		this.allowMultipleSignature = allowMultipleSignature;
	}





	/**
	 * @return the checkPAdESBES
	 */
	public synchronized String getCheckPAdESBES() {
		return checkPAdESBES;
	}





	/**
	 * @param checkPAdESBES the checkPAdESBES to set
	 */
	public synchronized void setCheckPAdESBES(String checkPAdESBES) {
		this.checkPAdESBES = checkPAdESBES;
	}





	/**
	 * @return the x
	 */
	public synchronized String getX() {
		return x;
	}





	/**
	 * @param x the x to set
	 */
	public synchronized void setX(String x) {
		this.x = x;
	}





	/**
	 * @return the y
	 */
	public synchronized String getY() {
		return y;
	}





	/**
	 * @param y the y to set
	 */
	public synchronized void setY(String y) {
		this.y = y;
	}





	/**
	 * @return the height
	 */
	public synchronized String getHeight() {
		return height;
	}





	/**
	 * @param height the height to set
	 */
	public synchronized void setHeight(String height) {
		this.height = height;
	}





	/**
	 * @return the width
	 */
	public synchronized String getWidth() {
		return width;
	}





	/**
	 * @param width the width to set
	 */
	public synchronized void setWidth(String width) {
		this.width = width;
	}





	/**
	 * @return the rotation
	 */
	public synchronized String getRotation() {
		return rotation;
	}





	/**
	 * @param rotation the rotation to set
	 */
	public synchronized void setRotation(String rotation) {
		this.rotation = rotation;
	}







	
	
	
	
}
