package es.caib.signatura.test.impl.signature.data;

import java.net.URL;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Node;

import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;


public class SingleSignatureExecutionData extends SignatureExecutionData {
	private String certName=null;
	private String password=null;
	private String contentType=null;
	
	public void parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		super.parseData(executionDirector, item);
		try{
			// Inicializar los objetos para las busquedas de elementos en el xml
	        XPathFactory factory = XPathFactory.newInstance();
	        XPath xpath = factory.newXPath();
	        
	        
	        // Extraer la información del xml xpath.evaluate(".",originalConfig2,XPathConstants.NODE)
	        setPassword((String)xpath.evaluate("./password",item,XPathConstants.STRING));
	        setCertName((String)xpath.evaluate("./certname",item,XPathConstants.STRING));
	        
	        setContentType((String)xpath.evaluate("./contenttype",item,XPathConstants.STRING));
		}catch(Throwable t){
			throw new ExecutionDataParseException(t.getMessage(), t);
		}
		
	}


	

	/**
	 * @return the certName
	 */
	public synchronized String getCertName() {
		return certName;
	}


	/**
	 * @param certName the certName to set
	 */
	public synchronized void setCertName(String certName) {
		this.certName = certName;
	}


	/**
	 * @return the pasword
	 */
	public synchronized String getPassword() {
		return password;
	}


	/**
	 * @param pasword the pasword to set
	 */
	public synchronized void setPassword(String password) {
		this.password = password;
	}


	


	/**
	 * @return the contentType
	 */
	public synchronized String getContentType() {
		return contentType;
	}


	/**
	 * @param contentType the contentType to set
	 */
	public synchronized void setContentType(String contentType) {
		this.contentType = contentType;
	}


	
	
	
}
