package es.caib.signatura.test.impl.signature.data;

import java.net.URL;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Node;

import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;


public class WSClientConfigurationExecutionData extends ExecutionData {
	private String unactiveProviders="";
	private String fileToSignURL;
	private String WSUsername=null;
	private String WSPassword=null;
	private String WSEndpoint=null;
	
	public void parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		try{
			// Inicializar los objetos para las busquedas de elementos en el xml
	        XPathFactory factory = XPathFactory.newInstance();
	        XPath xpath = factory.newXPath();
	        
	        
	        // Extraer la información del xml xpath.evaluate(".",originalConfig2,XPathConstants.NODE)
	        setUnactiveProviders((String)xpath.evaluate("./unactiveproviders",item,XPathConstants.STRING));
	        setFileToSignURL((String)xpath.evaluate("./filetosignurl",item,XPathConstants.STRING));
	        setWSUsername((String)xpath.evaluate("./wsusername",item,XPathConstants.STRING));
	        setWSPassword((String)xpath.evaluate("./wspassword",item,XPathConstants.STRING));
	        setWSEndpoint((String)xpath.evaluate("./wsendpoint",item,XPathConstants.STRING));
		}catch(Throwable t){
			throw new ExecutionDataParseException(t.getMessage(), t);
		}
		
	}


	/**
	 * @return the unactiveProviders
	 */
	public synchronized String getUnactiveProviders() {
		return unactiveProviders;
	}


	/**
	 * @param unactiveProviders the unactiveProviders to set
	 */
	public synchronized void setUnactiveProviders(String unactiveProviders) {
		this.unactiveProviders = unactiveProviders;
	}



	/**
	 * @return the fileToSignURL
	 */
	public synchronized String getFileToSignURL() {
		return fileToSignURL;
	}


	/**
	 * @param fileToSignURL the fileToSignURL to set
	 */
	public synchronized void setFileToSignURL(String fileToSignURL) {
		this.fileToSignURL = fileToSignURL;
	}


	/**
	 * @return the wSUsername
	 */
	public synchronized String getWSUsername() {
		return WSUsername;
	}


	/**
	 * @param wSUsername the wSUsername to set
	 */
	public synchronized void setWSUsername(String wSUsername) {
		WSUsername = wSUsername;
	}


	/**
	 * @return the wSPassword
	 */
	public synchronized String getWSPassword() {
		return WSPassword;
	}


	/**
	 * @param wSPassword the wSPassword to set
	 */
	public synchronized void setWSPassword(String wSPassword) {
		WSPassword = wSPassword;
	}


	/**
	 * @return the wSEndpoint
	 */
	public synchronized String getWSEndpoint() {
		return WSEndpoint;
	}


	/**
	 * @param wSEndpoint the wSEndpoint to set
	 */
	public synchronized void setWSEndpoint(String wSEndpoint) {
		WSEndpoint = wSEndpoint;
	}





	
	
	
}
