package es.caib.signatura.test.impl.signature.local.cms;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.SingleSignatureExecutionData;

/**
 * prueba de firma CMS válida
 * @author u91940
 *
 */
public class GoodCMSSignatureExecution extends SignatureExecution{
	private static final long serialVersionUID = 1L;

	public GoodCMSSignatureExecution(String name, String Description) {
		super(name, Description);
	}

	protected void executeSignature(Map globalVariables)  throws Throwable{	
		String inputURL=DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getFileToSignURL(),globalVariables);
		InputStream ins=new URL(inputURL).openStream();
		
		Signature s=getSigner().sign(
				ins
				,DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getCertName(),globalVariables)
				,DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getPassword(),globalVariables)
				,DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getContentType(),globalVariables)
				);
		setResult(s);
		
		try{
			ins.close();
		}catch(Throwable t){}
	}

	/**
	 * Verifica la firma
	 */
	public int verify(Map globalVariables) {
		Signature s=null;
		
		if(getResult()!=null){
			try{
				s=(Signature)getResult();
			}catch(Throwable t){
				t.printStackTrace();
				//no es una instancia de signature
				return 0;
			}
			try{
				int valid=-1;
				
				String inputURL=DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getFileToSignURL(),globalVariables);
				InputStream ins=new URL(inputURL).openStream();
				if(s.verify(ins)) valid= 1;
				else valid= 0;

				try{
					ins.close();
				}catch(Throwable t){}

				return valid;
			}catch(Throwable t){
				t.printStackTrace();
				return 0;
			}
		
		}else{
			return 0;
		}
		
	}

	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		SingleSignatureExecutionData d=new SingleSignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
}
