package es.caib.signatura.test.impl.signature.local.cms;

import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.InvalidSignatureExecutionData;

public class InvalidCMSSignatureVerificationExecution extends SignatureExecution{
	private static final long serialVersionUID = 1L;
	
	public InvalidCMSSignatureVerificationExecution(String name, String Description) {
		super(name, Description);
	}

	protected void executeSignature(Map globalVariables) throws Throwable {
	}
	
	public int verify(Map globalVariables) {
		try{
			URL serializedURL=new URL(
					DynamicQueryResolver.resolveString(
							((InvalidSignatureExecutionData)getData()).getInvalidSignatureFileURL()
							,globalVariables)
					);
			ObjectInputStream ois=new ObjectInputStream(serializedURL.openStream());
			Signature signature=(Signature)ois.readObject();
			
			URL documentURL=new URL(
					DynamicQueryResolver.resolveString(
							((InvalidSignatureExecutionData)getData()).getOriginalFileURL()
							,globalVariables)
					);
			
			boolean valid=signature.verify(documentURL.openStream());
			
			return (!valid)?VERIFICATION_OK:VERIFICATION_KO;
		}catch(Throwable t){
			if(t.getCause()==null || t.getCause().getMessage()==null){
				setResult(t);
				return Execution.VERIFICATION_KO;
			}else{
				if(t.getCause().getMessage().contains("invalid signature format in message: content hash found in signed attributes different")){
					return VERIFICATION_OK;
				}else{
					setResult(t);
					return Execution.VERIFICATION_KO;
				}
			}	
		}
		
	}
	
	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		InvalidSignatureExecutionData d=new InvalidSignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
}
