/**
 * 
 */
package es.caib.signatura.test.impl.signature.local.pdf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.SignatureException;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.CertifyDigitalCopyExecutionData;
import es.caib.signatura.test.impl.signature.data.PDFSingleSignatureExecutionData;
import es.caib.signatura.test.impl.signature.data.SignatureExecutionData;

/**
 * @author e43155798r
 *
 */
public class BadCertifyDigitalCopyExecution extends SignatureExecution {
	private static final long serialVersionUID = 1L;
	
	public BadCertifyDigitalCopyExecution(String name, String Description) {
		super(name, Description);
	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.test.impl.signature.SignatureExecution#executeSignature(java.util.Map)
	 */
	protected void executeSignature(Map globalVariables) throws Throwable {
		
//		String inputURL = DynamicQueryResolver.resolveString(
//				((PDFSingleSignatureExecutionData) getData())
//						.getFileToSignURL(), globalVariables);
//		InputStream ins = new URL(inputURL).openStream();
		
		String inputURL = DynamicQueryResolver.resolveString(
				((CertifyDigitalCopyExecutionData)getData())
						.getFileToSignURL(), globalVariables);
		
		InputStream ins = new URL(inputURL).openStream();
		ByteArrayOutputStream pdfOut = new ByteArrayOutputStream();
						
		getSigner().certifyDigitalCopy(
				ins
				,pdfOut
				,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getCertName(),globalVariables)
				,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getPassword(),globalVariables)
				,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getContentType(),globalVariables)
				,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampURL(),globalVariables)
				,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getLocalidad(),globalVariables)
				,Float.parseFloat(DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampPositionX(),globalVariables))
				,Float.parseFloat(DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampPositionY(),globalVariables))
				,Float.parseFloat(DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampRotation(),globalVariables))
		);
		
		//no establecemos el out porque debe dar una excepción, y la clase padrer se encarga de establecer el result a la excepcion
		try {
			
			ins.close();
			
		} catch(Throwable t) {
			
		}

	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.test.core.Execution#verify(java.util.Map)
	 */
	public int verify(Map globalVariables) {
		
		// Comprobar stdout mensaje de certificado no válido (cert no de empleado público)
		
		SignatureException s = null;

		if (getResult() != null) {
			try {
				s = (SignatureException) getResult();
			} catch (Throwable t) {
				t.printStackTrace();
				// no es una instancia de signature
				return 0;
			}
			System.out.println(s.getMessage());
			return Execution.VERIFICATION_OK;
		} else {
			return Execution.VERIFICATION_KO;
		}
	
	}
	
	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		CertifyDigitalCopyExecutionData d = new CertifyDigitalCopyExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}

}
