package es.caib.signatura.test.impl.signature.local.smime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.MultipleSignatureExecutionData;

/**
 * prueba de firma CMS válida
 * @author u91940
 *
 */
public class ParallelDettachedSmimeExecution extends SignatureExecution{
	private static final long serialVersionUID = 1L;

	private int validSignatures;
	private int invalidSignatures;
	private int signersLength=0;

	public ParallelDettachedSmimeExecution(String name, String Description) {
		super(name, Description);
	}

	protected void executeSignature(Map globalVariables)  throws Throwable{	
		InputStream ins=null;
		String inputURL=DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)getData()).getFileToSignURL(),globalVariables);
		
		signersLength=((MultipleSignatureExecutionData)getData()).getSignersLength();
		Signature s[]=new Signature[signersLength];
		
		for(int i=0;i<signersLength;i++){
			
			ins=new URL(inputURL).openStream();

			s[i]=getSigner().sign(
					ins
					,DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)getData()).getCertName(i),globalVariables)
					,DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)getData()).getPassword(i),globalVariables)
					,DynamicQueryResolver.resolveString(((MultipleSignatureExecutionData)getData()).getContentType(i),globalVariables)
					);
			
			try{
				ins.close();
			}catch(Throwable t){}
	
		}
		
		ins=new URL(inputURL).openStream();
		ByteArrayOutputStream out=new ByteArrayOutputStream();
		getSigner().generateSMIMEParalell(ins, s, out);

		setResult(out.toByteArray());
		
		try{
			ins.close();
			out.close();
		}catch(Throwable t){}

	}

	/**
	 * Verifica la firma
	 */
	public int verify(Map globalVariables) {
		String s=null;
		
		if(getResult()!=null){
			try{
				s=(String)getResult();
			}catch(Throwable t){
				t.printStackTrace();
				//no es una instancia de signature
				return 0;
			}
			try{
				
				SMIMEParser parser=getSigner().getSMIMEParser(new ByteArrayInputStream((byte[])getResult()));
				
				
				Signature vs[]=parser.getSignatures();
				for(int i=0;i<vs.length;i++){
					InputStream vis=new ByteArrayInputStream((byte [])parser.getSignedObject());
					if(vs[i].verify(vis)){
						validSignatures++;
					}else{
						invalidSignatures++;
					}

				}
				
				
				
			}catch(Throwable t){
				t.printStackTrace();
				return VERIFICATION_KO;
			}
			if(validSignatures==signersLength && invalidSignatures==0) return VERIFICATION_OK;
			else return VERIFICATION_KO;
		}else{
			return VERIFICATION_KO;
		}
		
	}

	
	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		MultipleSignatureExecutionData d=new MultipleSignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
}
