package es.caib.signatura.test.impl.signature.local.smime;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.InvalidSignatureExecutionData;

public class RevokedCertSMIMESignatureVerificationExecution extends SignatureExecution {
	private static final long serialVersionUID = 1L;
		
		public RevokedCertSMIMESignatureVerificationExecution(String name, String Description) {
			super(name, Description);
		}

		protected void executeSignature(Map globalVariables) throws Throwable {
		}
		
		public int verify(Map globalVariables) {
			try{
				URL serializedURL=new URL(
						DynamicQueryResolver.resolveString(
								((InvalidSignatureExecutionData)getData()).getInvalidSignatureFileURL()
								,globalVariables)
						);
				SMIMEParser parser=getSigner().getSMIMEParser(serializedURL.openStream());
				boolean validSMIME=true;
				byte document[]=(byte [])parser.getSignedObject();
				Signature signatures[]=parser.getSignatures();
				int i=0;
				for(i=0;i<signatures.length;i++){
					boolean validSignature=signatures[i].verify();
					validSMIME=validSMIME && validSignature;
				}
				
				
				return (!validSMIME)?Execution.VERIFICATION_OK:Execution.VERIFICATION_KO;
				//lanza una excepción si la firma no es válida.
			}catch(Throwable t){
				setResult(t);
				return VERIFICATION_KO;
			}
			
		}
		
		public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
			InvalidSignatureExecutionData d=new InvalidSignatureExecutionData();
			d.parseData(executionDirector, item);
			return d;
		}
	
	
}
