package es.caib.signatura.test.impl.signature.local.smime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.SingleSignatureExecutionData;

/**
 * prueba de firma CMS válida
 * @author u91940
 *
 */
public class SingleDettachedSmimeExecution extends SignatureExecution{
	private static final long serialVersionUID = 1L;

	private int validSignatures;
	private int invalidSignatures;

	public SingleDettachedSmimeExecution(String name, String Description) {
		super(name, Description);
	}

	protected void executeSignature(Map globalVariables)  throws Throwable{	
		String inputURL=DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getFileToSignURL(),globalVariables);
		InputStream ins=new URL(inputURL).openStream();
		
		Signature s=getSigner().sign(
				ins
				,DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getCertName(),globalVariables)
				,DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getPassword(),globalVariables)
				,DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getContentType(),globalVariables)
				);
		
		try{
			ins.close();
		}catch(Throwable t){}
		
		
		ins=new URL(inputURL).openStream();
		ByteArrayOutputStream out=new ByteArrayOutputStream();
		getSigner().generateSMIME(ins, s, out);
		setResult(out.toByteArray());
		
		try{
			ins.close();
			out.close();
		}catch(Throwable t){}

	}

	/**
	 * Verifica la firma
	 */
	public int verify(Map globalVariables) {
		byte[] s=null;
		
		if(getResult()!=null){
			try{
				s=(byte[])getResult();
				setResult(new ByteArrayInputStream(s));
			}catch(Throwable t){
				t.printStackTrace();
				//no es una instancia de signature
				return 0;
			}
			try{
				
				SMIMEParser parser=getSigner().getSMIMEParser((ByteArrayInputStream)getResult());
				
				Signature vs[]=parser.getSignatures();
				for(int i=0;i<vs.length;i++){
					InputStream vis=new ByteArrayInputStream((byte [])parser.getSignedObject());
					if(vs[i].verify(vis)){
						validSignatures++;
					}else{
						invalidSignatures++;
					}

				}
				
				
				
			}catch(Throwable t){
				t.printStackTrace();
				setResult(t);
				return VERIFICATION_KO;
			}
			if(validSignatures==1 && invalidSignatures==0) return VERIFICATION_OK;
			else return VERIFICATION_KO;
		}else{
			return VERIFICATION_KO;
		}
		
	}

	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		SingleSignatureExecutionData d=new SingleSignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
}
