package es.caib.signatura.test.impl.signature.manual.cms;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.impl.signature.data.SingleSignatureExecutionData;
import es.caib.signatura.test.impl.signature.local.cms.GoodCMSSignatureExecution;

public class ManualVerificationGoodCMSSignatureExecution extends GoodCMSSignatureExecution {
	private static final long serialVersionUID = 1L;

	public ManualVerificationGoodCMSSignatureExecution(String name, String Description) {
		super(name, Description);
	}

	/**
	 * Verifica la firma
	 */
	public int verify(Map globalVariables) {
		Signature s=null;
		
		if(getResult()!=null){
			try{
				s=(Signature)getResult();
			}catch(Throwable t){
				t.printStackTrace();
				//no es una instancia de signature
				return 0;
			}
			try{
				int valid=-1;
				
				String inputURL=DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)getData()).getFileToSignURL(),globalVariables);
				InputStream ins=new URL(inputURL).openStream();
				
				if(s.verify(ins)){
					//escribimos en un fichero el resultado
					setResult(s.getCert().toString());
					valid= Execution.VERIFICATION_MANUAL; //manual
				}else{
					valid= Execution.VERIFICATION_KO;
				}

				try{
					ins.close();
				}catch(Throwable t){}

				return valid;
			}catch(Throwable t){
				t.printStackTrace();
				return Execution.VERIFICATION_KO;
			}
		
		}else{
			return Execution.VERIFICATION_KO;
		}
		
	}
}
