package es.caib.signatura.test.impl.signature.manual.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import org.w3c.dom.Node;

import es.caib.signatura.api.SignatureException;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.CertifyDigitalCopyExecutionData;
import es.caib.signatura.test.impl.signature.data.PDFSingleSignatureExecutionData;


/**
 * prueba de firma CMS válida
 * @author u91940
 *
 */
public class GoodPDFCertifyDigitalCopyExecution extends SignatureExecution{
	private static final long serialVersionUID = 1L;
    /** OID Para el atributo que contiene los timestamp de los signer's*/
    public int expectedSignersLength=1;
    
	public GoodPDFCertifyDigitalCopyExecution(String name, String Description) {
		super(name, Description);
	}

	protected void executeSignature(Map globalVariables)  throws Throwable{	
		String inputURL=DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getFileToSignURL(),globalVariables);
		InputStream ins=new URL(inputURL).openStream();
		
		ByteArrayOutputStream pdfOut=new ByteArrayOutputStream();
			getSigner().certifyDigitalCopy(
					ins
					,pdfOut
					,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getCertName(),globalVariables)
					,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getPassword(),globalVariables)
					,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getContentType(),globalVariables)
					,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampURL(),globalVariables)
					,DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getLocalidad(),globalVariables)
					,Float.parseFloat(DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampPositionX(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampPositionY(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((CertifyDigitalCopyExecutionData)getData()).getStampRotation(),globalVariables))
			);
			setResult(pdfOut.toByteArray());
		try{
			ins.close();
		}catch(Throwable t){}
	}

	/**
	 * Verifica la firma
	 */
	public int verify(Map globalVariables) {
		byte[] documento=null;
		if(getResult()!=null){
			try{
				documento=(byte[])getResult();
	        	setResult(documento);
	        	return Execution.VERIFICATION_MANUAL; //manual
		        
				
			}catch(Throwable t){
				t.printStackTrace();
				//manual, preparem upload
				setResult(documento);
				return Execution.VERIFICATION_KO;
			}

		
		}else{
			setResult(documento);
			return Execution.VERIFICATION_KO;
		}
	}




	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		CertifyDigitalCopyExecutionData d=new CertifyDigitalCopyExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
	
	
	
	
}

