package es.caib.signatura.test.impl.signature.manual.pdf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Node;

import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.PDFSingleSignatureExecutionData;


/**
 * prueba de firma CMS válida
 * @author u91940
 *
 */
public class ManualVerificationGoodPDFSignatureExecution extends SignatureExecution{
	private static final long serialVersionUID = 1L;
	
    /** OID Para el atributo que contiene los timestamp de los signer's*/
    public int expectedSignersLength=1;
    
	public ManualVerificationGoodPDFSignatureExecution(String name, String Description) {
		super(name, Description);
	}

	protected void executeSignature(Map globalVariables)  throws Throwable{	
		String inputURL=DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getFileToSignURL(),globalVariables);
		InputStream ins=new URL(inputURL).openStream();
		
		ByteArrayOutputStream pdfOut=new ByteArrayOutputStream();
			
		String sx=DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getX(),globalVariables);
		if(sx!=null && !"".equals(sx)){
			//firma posicionada en coordenadas
			getSigner().signPDF(
					ins
					,pdfOut
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getCertName(),globalVariables)
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getPassword(),globalVariables)
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getContentType(),globalVariables)
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getStampURL(),globalVariables)
					,Integer.parseInt(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getStampPosition(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getY(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getX(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getHeight(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getWidth(),globalVariables))
					,Float.parseFloat(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getRotation(),globalVariables))
					,Boolean.parseBoolean(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).isAllowMultipleSignature(),globalVariables))
					);
		}else{
			//firma no posicionada por coordenadas
		
			getSigner().signPDF(
					ins
					,pdfOut
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getCertName(),globalVariables)
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getPassword(),globalVariables)
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getContentType(),globalVariables)
					,DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getStampURL(),globalVariables)
					,Integer.parseInt(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).getStampPosition(),globalVariables))
					,Boolean.parseBoolean(DynamicQueryResolver.resolveString(((PDFSingleSignatureExecutionData)getData()).isAllowMultipleSignature(),globalVariables))
					);
		}
		setResult(pdfOut.toByteArray());
		try{
			ins.close();
		}catch(Throwable t){}
	}

	/**
	 * Verifica la firma
	 */
	public int verify(Map globalVariables) {
		byte[] documento=null;
		
		if(getResult()!=null){
			try{
				documento=(byte [])getResult();
	        	setResult(documento);
	        	return Execution.VERIFICATION_MANUAL;
		        
				
			}catch(Throwable t){
				t.printStackTrace();
				//manual, preparem upload
				if(documento!=null){
					setResult(documento);
					return Execution.VERIFICATION_MANUAL;
				}else{
					setResult(t);
					return Execution.VERIFICATION_KO;
				}
			}

		
		}else{
			setResult(null);
			return Execution.VERIFICATION_KO;
		}
		
	}






	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		PDFSingleSignatureExecutionData d=new PDFSingleSignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
	
	
	
	
}

