package es.caib.signatura.test.impl.signature.remote.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.w3c.dom.Node;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;

import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.CAIBSigner;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.core.RemoteExecutionVerification;
import es.caib.signatura.test.impl.signature.data.PDFSingleSignatureExecutionData;
import es.caib.signatura.test.privileged.utils.SignatureTestUtils;


public class BadPDFExecutionRemoteVerifier implements RemoteExecutionVerification{
	private static final long serialVersionUID = 1L;



    public static DERObjectIdentifier OID_TIMESTAMP_SIGNER = new DERObjectIdentifier("1.2.840.113549.1.9.16.2.14");    
    public int expectedSignersLength=1;
    

	/**
	 * Verifica la firma
	 */
	public Integer verify(Execution ex,Map globalVariables) {
		try{
			if(Security.getProvider("BC") == null){ 
				Provider p = (Provider) new org.bouncycastle.jce.provider.BouncyCastleProvider();
				Security.addProvider(p);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		
		SignatureException exception=null;
		
		if(ex.getResult()!=null){
			try{
				exception=(SignatureException)ex.getResult();
				return new Integer(Execution.VERIFICATION_OK);
			}catch(Throwable t){
				t.printStackTrace();
				return new Integer(Execution.VERIFICATION_KO);
			}

		
		}else{
			ex.setResult(ex.getResult());
			return new Integer(Execution.VERIFICATION_KO);
		}
		
	}

	public boolean analizar(Execution ex,Map globalVariables,PDFSingleSignatureExecutionData data,byte [] documento,int expectedSignersLength) throws Exception {

        PdfReader pdfReader = null;
        AcroFields acroFields = null;
    	pdfReader = new PdfReader(new ByteArrayInputStream(documento));
        acroFields = pdfReader.getAcroFields();

        // Verificaci�n de firmas
        ArrayList signatureNames = acroFields.getSignatureNames();
        Collections.sort(signatureNames);
        
        //verificamos el número de firmantes
        if(expectedSignersLength!=signatureNames.size())
        	return false;
        
        int i = 0;
        for (i = 0; i < signatureNames.size(); i++) {
            String sigName = (String)signatureNames.get(i);
            try {
                if (!acroFields.verifySignature(sigName, "BC").verify()) {
                    throw new Exception("La firma '" + sigName + "' no es valida en el documento PDF");
                }
            } catch (SignatureException e) {
                throw new Exception("Error verificando firma '" + sigName + "' en el documento PDF");
            }
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(sigName);
            PdfObject ob = pdfDictionary.get(PdfName.CONTENTS);
            // Nota: al verificar el CMS ya se verifican la mayor�a de condiciones para cumplir PAdES-BES, sobre SignedData
            CMSSignedData signedData = new CMSSignedData(ob.getBytes());
            
            if (Boolean.parseBoolean(DynamicQueryResolver.resolveString(data.getCheckPAdESBES(),globalVariables))) {
                if (pdfDictionary.get(PdfName.CERT) != null) {
                    throw new Exception("No puede haber una entrada CERT en el diccionario para cumplir PAdES BES");
                }
                if (!pdfDictionary.get(PdfName.SUBFILTER).toString().equals("ETSI.CAdES.detached")) {
                    throw new Exception("La entrada SUBFILTER del diccionario debe contener ETSI.CAdES.detached para cumplir PAdES BES");
                }
                // Recordar: si a�adimos alg�n timestamp nosotros para obtener lo an�logo a un CAdES-T pero en PAdES,
                // no podremos modificar el PKCS7 del PDF. Limitaci�n de la libreria iText, por ahora.
            }
            
            //no verificamos timestamp porque tenemos problemas
        }
        
        return true;
        
    }
	
	 protected boolean verificarTimestamps(CMSSignedData cmsSignedData) throws Exception {
        CertStore certs = cmsSignedData.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signerInformationStore = cmsSignedData.getSignerInfos();
        ArrayList signers = new ArrayList(signerInformationStore.getSigners());
        Iterator it = signers.iterator();
        boolean verified=true;
        
        while (it.hasNext()) {

                //Cada signer es una firma del nivel
                //Obtenemos los certificados que deben validar la firma
                SignerInformation signer = (SignerInformation) it.next();
                
                List sellos = recuperarSellosFirmanteSigner(signer);
                byte[] digest=signer.getContentDigest();
                Iterator it2=sellos.iterator();
                while(it2.hasNext()){
                	TimeStampToken tst=(TimeStampToken)it.next();
                	verified=(verified && verifyTimestamp(tst, signer, digest));
                }
                

            }
        return verified;
    }
	
  public static List recuperarSellosFirmanteSigner(SignerInformation signer) throws Exception {
    List sellos=new ArrayList();
    byte encoded[] = null;
    TimeStampToken tst = null;
    CMSSignedData contentInfo = null;    

      //Por ultimo si el signer tiene un sello de tiempo este se verificar� y se tendra que almacenar en B.D. 
      if (signer.getUnsignedAttributes()==null) return sellos;
      Attribute att = signer.getUnsignedAttributes().get(OID_TIMESTAMP_SIGNER);
      if (att!=null) {    
        ASN1Set values = att.getAttrValues();
        for (int ia=0;ia<values.size();ia++) {
          DEREncodable token = values.getObjectAt(ia);              
          encoded = token.getDERObject().getDEREncoded();
          contentInfo = new CMSSignedData(encoded);          
          tst = new TimeStampToken(contentInfo);
          sellos.add(tst);
        }
      }
      return sellos;

    
  } 
  
  protected boolean verifyTimestamp(TimeStampToken tst, SignerInformation si,
			byte[] documentDigest) throws SignatureProviderException,
			IOException, SignatureVerifyException {
		boolean timeStampVerified = false;
		try {
			byte signatureDigest [] = digest(si.getSignature());
			if (tst != null) {
				CertStore certs = tst
						.getCertificatesAndCRLs("Collection", "BC");
				if (certs != null) {
					Collection certificates = certs.getCertificates(tst
							.getSID());
					if (certificates != null && certificates.size() > 0) {
						X509Certificate timeStampCertificate = getTimeStampCertificates(certificates)[0];
						try {
							tst.validate(timeStampCertificate, "BC");
							timeStampVerified = true;
							TimeStampTokenInfo tsTokenInfo = tst.getTimeStampInfo();
							byte[] hashTimeStamp = tsTokenInfo.getMessageImprintDigest();
							timeStampVerified = timeStampVerified && hashTimeStamp.length == signatureDigest.length;
							for (int i = 0; i < signatureDigest.length && timeStampVerified; i++) {
								timeStampVerified = timeStampVerified && (hashTimeStamp[i] == signatureDigest[i]);
							}
						} catch (Exception e) {
							throw new SignatureVerifyException(e);
						}
					}
				}
			}
		} catch (Exception e) {
			throw new SignatureVerifyException(e);
		}
		return timeStampVerified;
	}

	public static byte[] digest (byte data[]) throws NoSuchAlgorithmException, NoSuchProviderException
	{
	  	MessageDigest digester;
  		digester  = MessageDigest.getInstance("SHA-1", "BC");
  		digester.update(data);
  		return digester.digest();
	}



	public X509Certificate[] getTimeStampCertificates(Collection certCollection)
		throws Exception {
		Iterator certIt = certCollection.iterator();
		Vector v = new Vector();
		while (certIt.hasNext()) {
			v.add(certIt.next());
		}
		return (X509Certificate[]) v.toArray(new X509Certificate[v.size()]);
	}






	public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
		PDFSingleSignatureExecutionData d=new PDFSingleSignatureExecutionData();
		d.parseData(executionDirector, item);
		return d;
	}
	
	
	




}
