package es.caib.signatura.test.views;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;

import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.core.ExecutionView;
import es.caib.signatura.test.core.RemoteExecutionVerificationRequest;
import es.caib.signatura.test.core.StatusChangeEventListener;
import es.caib.signatura.test.core.SynchronizableBoolean;

public class TestJNLPFrame extends JFrame implements ActionListener,ExecutionView,StatusChangeEventListener{

	private ExecutionDirector director=new ExecutionDirector();  //  @jve:decl-index=0:
	
	private JPanel jContentPane = null;
	private JScrollPane jScrollPane = null;
	private JPanel jPanelCenter = null;
	private JLabel jLabelTitle = null;

	private SynchronizableBoolean userInputLock=new SynchronizableBoolean(true);  //  @jve:decl-index=0:

	private Vector executions=new Vector();  //  @jve:decl-index=0:

	private Vector checkboxes=new Vector();
	private Vector executionPanels=new Vector();  //  @jve:decl-index=0:

	private String requestedAction;

	private JPanel jPanelBottom = null;

	private JButton jButtonBegin = null;

	private JButton jButtonStop = null;

	private JButton jButtonShowResults = null;

	private JButton jButtonExportResults = null;

	private String monitorServletURL;

	private String configFilePath;

	private boolean configured;

  //  @jve:decl-index=0:


	/**
	 * This is the xxx default constructor
	 */
	public TestJNLPFrame(String configFilePath,String monitorServletURL) {
		super();
		this.configFilePath=configFilePath;
		this.monitorServletURL=monitorServletURL;
		this.setTitle("Proves de funcionalitat (signaturacaib)");
		init();
		this.addWindowListener(new WindowAdapter()
	      {
	        public void windowClosing(WindowEvent e)
	        {
	          System.exit(0);
	        }
	      });
		this.setVisible(true);
		start();
		
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	public void init() {
		this.setSize(500, 500);
		this.setPreferredSize(new Dimension(500, 500));
		this.setContentPane(getJContentPane());
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabelTitle = new JLabel();
			jLabelTitle.setText("Applet de verificació de funcionalitats");
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.setPreferredSize(new Dimension(400, 400));
			jContentPane.add(getJScrollPane(), BorderLayout.CENTER);
			jContentPane.add(jLabelTitle, BorderLayout.NORTH);
			jContentPane.add(getJPanelBottom(), BorderLayout.SOUTH);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJPanelCenter());
			jScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			jScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jPanelCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BoxLayout(jPanelCenter, BoxLayout.Y_AXIS));
			
		}
		return jPanelCenter;
	}

	/**
	 * This method initializes jPanelFunc1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelFunc1(String name,boolean active) {
		JPanel jPanelFunc1;
			JLabel jLabelFunc1Title = new JLabel();
			jLabelFunc1Title.setText(name);
			jPanelFunc1 = new JPanel();
			jPanelFunc1.setLayout(new BoxLayout(jPanelFunc1, BoxLayout.X_AXIS));
			jPanelFunc1.add(jLabelFunc1Title, null);
			JCheckBox check=getJCheckBoxFunc1Active(active);
			jPanelFunc1.add(check, null);
			checkboxes.add(check);
			executionPanels.add(jPanelFunc1);
		return jPanelFunc1;
	}

	/**
	 * This method initializes jCheckBoxFunc1Active	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBoxFunc1Active(boolean active) {
		JCheckBox jCheckBoxFunc1Active;
		jCheckBoxFunc1Active = new JCheckBox();
		jCheckBoxFunc1Active.setSelected(active);
	
		return jCheckBoxFunc1Active;
	}
	
	public void start() {

		director.setView(this);
		director.setMonitorServletURL(monitorServletURL);
		director.setConfigURL(configFilePath);
		director.start();
		
		
	}

	public void closeView() {
		// TODO Auto-generated method stub
		
	}

	public void notifyFatal(String message, Exception e) {
		e.printStackTrace();
		JOptionPane.showMessageDialog(null,message, "Error" , JOptionPane.ERROR_MESSAGE);
	}

	public String queryActions() {
		//esperar hasta que se haya pulsado el botón de empezar
		if(configured){
			//este if es para que no tengamos que pulsar dos veces el botón de start
			configured=false;
		}else{
			synchronized(userInputLock){
				while(userInputLock.get()){
					try {
						userInputLock.wait();
					} catch (InterruptedException e) {
						
					}
				}
				//volvemos a establecer el bloqueo que indica que el mando lo tiene el usuario
				userInputLock.set(true);
			}
		}
		
		enableUserActions(false);
		return requestedAction;
	}

	public Vector queryUserExecutionsConfig() {
		
		//esperar hasta que se haya pulsado el botón de empezar
		synchronized(userInputLock){
			while(userInputLock.get()){
				try {
					userInputLock.wait();
				} catch (InterruptedException e) {
					
				}
			}
			//volvemos a establecer el bloqueo que indica que el mando lo tiene el usuario
			userInputLock.set(true);
		}

		int i=0;
		Iterator it=executions.iterator();
		while(it.hasNext()){
			Execution ex=(Execution)it.next();
			JCheckBox check=(JCheckBox)checkboxes.get(i);
			ex.setActive(check.isSelected());
			
			//actualització online del estat de l'execució
			List statusChangeListeners=ex.getStatusChangeListeners();
			statusChangeListeners.add(this);
			ex.setStatusChangeListeners(statusChangeListeners);
			i++;
		}
		configured=true;
		enableUserActions(true);
		return executions;
	}

	public void showAvailableExecutions(Vector executions) {
		this.executions=executions;
		Iterator it=executions.iterator();
		while(it.hasNext()){
			Execution ex=(Execution)it.next();
			getJPanelCenter().add(getJPanelFunc1(ex.getName(),ex.isActive()));
		}
		this.validate();	
	}

	public void updateResults(Vector executions) {

		this.executions=executions;
		Iterator it=executions.iterator();
		int i=0;
		while(it.hasNext()){
			Execution ex=(Execution)it.next();
			if(ex.isActive()){
				JPanel panel=(JPanel)executionPanels.get(i);
				
				
				int result=ex.getVerificationResult().intValue();
				if(result==1){
					JLabel resultLabel=new JLabel(new ImageIcon(this.getClass().getResource("ok.gif")));
					panel.add(resultLabel);
				}else if(result==0){
					JLabel resultLabel=new JLabel(new ImageIcon(this.getClass().getResource("ko.gif")));
					panel.add(resultLabel);				
				}else{
					JLabel resultLabel=new JLabel(new ImageIcon(this.getClass().getResource("manual.gif")));
					panel.add(resultLabel);
				}
			}
			i++;
		}		
		this.validate();
	}



	/**
	 * This method initializes jPanelBottom	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelBottom() {
		if (jPanelBottom == null) {
			jPanelBottom = new JPanel();
			jPanelBottom.setLayout(new FlowLayout());
			jPanelBottom.add(getJButtonBegin(), null);
			jPanelBottom.add(getJButtonShowResults(), null);
			jPanelBottom.add(getJButtonExportResults(), null);
		}
		return jPanelBottom;
	}

	/**
	 * This method initializes jButtonBegin	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonBegin() {
		if (jButtonBegin == null) {
			jButtonBegin = new JButton();
			jButtonBegin.setText("Start");
			jButtonBegin.setActionCommand(ExecutionDirector.ACTION_START_EXECUTIONS);
			jButtonBegin.addActionListener((ActionListener) this);
		}
		return jButtonBegin;
	}


	/**
	 * This method initializes jButtonShowResults	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonShowResults() {
		if (jButtonShowResults == null) {
			jButtonShowResults = new JButton();
			jButtonShowResults.setText("Show results");
			jButtonShowResults.setActionCommand(ExecutionDirector.ACTION_SHOW_RESULTS);
			jButtonShowResults.addActionListener(this);

		}
		return jButtonShowResults;
	}
	
	public void actionPerformed(java.awt.event.ActionEvent e) {
		enableUserActions(false);
		
		this.requestedAction=e.getActionCommand();
		synchronized (userInputLock) {
			userInputLock.set(false);
			userInputLock.notifyAll();			
		}

	}



	/**
	 * This method initializes jButtonExportResults	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonExportResults() {
		if (jButtonExportResults == null) {
			jButtonExportResults = new JButton();
			jButtonExportResults.setText("Export results");
			jButtonExportResults.setActionCommand(ExecutionDirector.ACTION_EXPORT_RESULTS);
			jButtonExportResults.addActionListener(this);

		}
		return jButtonExportResults;
	}

	public void exportResults(String export) {
		
		String pluginVersion=System.getProperty("java.runtime.version");
		String agentVersion="Java Web Start";
		String export1=export.substring(0,export.indexOf('\n')+1).replaceFirst("([^\n]*)\n", "Navegador|Plugin|$1\n");
		String export2=export.substring(export.indexOf('\n')+1,export.length()).replaceAll("([^\n]*)\n", agentVersion+"|"+pluginVersion+"|$1\n");
		String extendedExport=export1+export2;


		
		if(monitorServletURL!=null){
			try {
				enableUserActions(false);
				URL url=new URL(monitorServletURL);
				
				// Generar la firma
				HttpURLConnection c = (HttpURLConnection) url.openConnection();
				c.addRequestProperty("configFilePath", configFilePath);
				c.setDoInput(true);
				c.setDoOutput(true);
				c.setRequestMethod("GET");
				c.connect();
				OutputStream o = c.getOutputStream();
				o.write(extendedExport.getBytes());
				o.close();
				String response=readInputStream(c.getInputStream());
				System.out.println(response);
				c.disconnect();
				
				
			} catch (Exception e) {
				notifyFatal(e.getMessage(), e);
				e.printStackTrace();
			}finally{
				enableUserActions(true);
			}
			
			
		}else{
			JTextArea area=new JTextArea();
			area.setText(extendedExport);
			getJPanelCenter().add(area);
			this.validate();
		}
		
		
	}

	private String readInputStream(InputStream inputStream) throws IOException {
		ByteArrayOutputStream out=new ByteArrayOutputStream();
		BufferedInputStream in = new BufferedInputStream (inputStream);
        byte [] b = new byte [8192];
        
        int read=0;
        while ((read = in.read(b)) > 0)
        {
        	out.write(b,0,read);
        }
        in.close();
        
        return out.toString("UTF-8");

		
	}

	private void enableUserActions(boolean b) {
		getJButtonBegin().setEnabled(b);
		getJButtonExportResults().setEnabled(b);
		getJButtonShowResults().setEnabled(b);		
	}
	public void onFinalizeExecutions() {
		enableUserActions(true);
	}
	
	public void executionStatusUpdated(Execution source,Map globalVariables,int oldStatus, int newStatus) {
		if(oldStatus==Execution.STATUS_RUNNING && newStatus==Execution.STATUS_DONE){
			JPanel panel=null;
			int i=0;
			while(true){
				panel=(JPanel)executionPanels.get(i);
				if(((JLabel)panel.getComponent(0)).getText().equals(source.getName())){
					break;
				}
				i++;
			}
					
			int result=0;
			//no es pot verificar més d'una vegada
			if(source.getVerificationResult()==null){
				result=source.verify(globalVariables);
				source.setVerificationResult(new Integer(result));
			}else{
				result=source.getVerificationResult().intValue();
			}
			if(result==-2){
				//verificación remota
				try{
					result=executeRemoteVerification(source,globalVariables);
					source.setVerificationResult(new Integer(result));
				}catch(Exception e){
					notifyFatal(e.getMessage(), e);
				}
			}
			if(result==1){
				JLabel resultLabel=new JLabel(new ImageIcon(this.getClass().getResource("ok.gif")));
				panel.add(resultLabel);
			}else if(result==0){
				JLabel resultLabel=new JLabel(new ImageIcon(this.getClass().getResource("ko.gif")));
				panel.add(resultLabel);				
			}else if(result==-1){
				JLabel resultLabel=new JLabel(new ImageIcon(this.getClass().getResource("manual.gif")));
				panel.add(resultLabel);
			}
			
			validate();	
			
		}
	}
	
	private int executeRemoteVerification(Execution ex, Map globalVariables) throws Exception{
		String remoteVerificationServlet=monitorServletURL.replace("ResultsCollectorServlet", "RemoteVerificationServlet");
		URL uploadServletURL=new URL(remoteVerificationServlet);
		RemoteExecutionVerificationRequest verificationReq=new RemoteExecutionVerificationRequest(ex,globalVariables );
		
		// Generar la firma
		HttpURLConnection c = (HttpURLConnection) uploadServletURL.openConnection();
		c.setDoInput(true);
		c.setDoOutput(true);
		c.setRequestMethod("POST");
		c.connect();
		ObjectOutputStream o = new ObjectOutputStream(c.getOutputStream());
		o.writeObject(verificationReq);
		o.flush();
		o.close();
		String response=readInputStream(c.getInputStream());
		c.disconnect();
		if(c.getResponseCode()!=200)
			return Execution.VERIFICATION_KO;
		else
			return Integer.parseInt(response);
	}
	
	
	public static void main(String[] args) {
		if(args.length!=2){
			System.err.println("missing arguments configFileUrl and MonitorServletURL ");
			System.exit(1);
		}
		if(args.length==1)
			new TestJNLPFrame(args[0], null);
		else
			new TestJNLPFrame(args[0], args[1]);
	}



}

