package es.caib.signatura.test.views;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.core.ExecutionView;

public class TestStandaloneApp implements ExecutionView{
	
		private ExecutionDirector director=new ExecutionDirector();  //  @jve:decl-index=0:
		
		private JPanel jContentPane = null;
		private JScrollPane jScrollPane = null;
		private JPanel jPanelCenter = null;
		private JLabel jLabelTitle = null;

		private SynchronizableBoolean userInputLock=new SynchronizableBoolean(true);  //  @jve:decl-index=0:

		private Vector executions=new Vector();  //  @jve:decl-index=0:

		private Vector checkboxes=new Vector();
		private Vector executionPanels=new Vector();  //  @jve:decl-index=0:

		private String requestedAction;

		private JPanel jPanelBottom = null;

		private JButton jButtonBegin = null;

		private JButton jButtonStop = null;

		private JButton jButtonShowResults = null;

		private JButton jButtonExportResults = null;

		private String monitorServletURL;

		private String configFilePath;

		private boolean executionsHaveEnded=false;

		private boolean exportedResults=false;

		private String additionalName;;

	  //  @jve:decl-index=0:






		
		public void start(String additionalName,String configFilePath,String monitorServletURL ) {
				this.configFilePath=configFilePath;
				this.monitorServletURL=monitorServletURL;
				this.additionalName=additionalName;
				
				director.setMonitorServletURL(monitorServletURL);
				director.setConfigURL(configFilePath);
				director.setView(this);
				director.start();
			
			
		}

		public void closeView() {
			// TODO Auto-generated method stub
			
		}

		public void notifyFatal(String message, Exception e) {
			e.printStackTrace();
		}

		//iniciem els experiments
		public String queryActions() {
			if(!executionsHaveEnded){
				return ExecutionDirector.ACTION_START_EXECUTIONS;
			}else if(!exportedResults){
				exportedResults=true;
				return ExecutionDirector.ACTION_EXPORT_RESULTS;
			}else{
				return ExecutionDirector.ACTION_DESTROY;
			}
		}

		public Vector queryUserExecutionsConfig() {
			return executions;
		}

		public void showAvailableExecutions(Vector executions) {
			this.executions=executions;
		}

		public void updateResults(Vector executions) {

			this.executions=executions;
			Iterator it=executions.iterator();
			int i=0;
			while(it.hasNext()){
				Execution ex=(Execution)it.next();
				if(ex.isActive()){
					JPanel panel=(JPanel)executionPanels.get(i);
					
					int result=ex.getVerificationResult().intValue();
					if(result==1){
						System.out.println(ex.getName()+" : OK");
					}else if(result==0){
						System.out.println(ex.getName()+" : KO");
					}else{
						System.out.println(ex.getName()+" : MANUAL");
					}
				}
				i++;
			}		

		}



		private class SynchronizableBoolean{
			boolean bool=true;
			SynchronizableBoolean(boolean value){
				this.bool=value;
			}
			
			public synchronized boolean get(){
				return this.bool;
			}
			
			public synchronized void set(boolean value){
				this.bool=value;
			}
			
			
		}



		



		
		public void exportResults(String export) {
			
			if(monitorServletURL!=null){
				try {

					URL url=new URL(monitorServletURL);
					String export1=export.substring(0,export.indexOf('\n')+1).replaceFirst("([^\n]*)\n", "Other1|Other2|$1\n");
					String export2=export.substring(export.indexOf('\n')+1,export.length()).replaceAll("([^\n]*)\n", additionalName+"||$1\n");
					String extendedExport=export1+export2;
					
					// Generar la firma
					HttpURLConnection c = (HttpURLConnection) url.openConnection();
					c.addRequestProperty("configFilePath", configFilePath);
					c.setDoInput(true);
					c.setDoOutput(true);
					c.setRequestMethod("GET");
					c.connect();
					OutputStream o = c.getOutputStream();
					o.write(extendedExport.getBytes());
					o.close();
					String response=readInputStream(c.getInputStream());
					System.out.println(response);
					c.disconnect();
					
					
				} catch (Exception e) {
					notifyFatal(e.getMessage(), e);
					e.printStackTrace();
				}finally{

				}
				
				
			}else{
				System.out.println("--------------------- BEGIN TEST RESULTS------------------");
				System.out.println(export);
				System.out.println("---------------------END TEST RESULTS------------------");

			}
			
			
		}

		private String readInputStream(InputStream inputStream) throws IOException {
			ByteArrayOutputStream out=new ByteArrayOutputStream();
			BufferedInputStream in = new BufferedInputStream (inputStream);
	        byte [] b = new byte [8192];
	        
	        int read=0;
	        while ((read = in.read(b)) > 0)
	        {
	        	out.write(b,0,read);
	        }
	        in.close();
	        
	        return out.toString("UTF-8");

			
		}

		public void onFinalizeExecutions() {
			executionsHaveEnded=true;
		}

	
	
	public static void main(String[] args) {
		TestStandaloneApp h=new TestStandaloneApp();
		if(args.length>3 || args.length==0)
			System.err.println("Usage params: [extendedInfoColumn] [config file URL] [optional monitor servlet URL]");
		else
			h.start(args[0],args[1],args[2]);
		
	}
}
