package es.caib.signatura.test.views;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import es.caib.signatura.test.core.ProcessHelper;


public class TestStandaloneAppLauncher extends HttpServlet {
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	    
		String base = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/"+request.getContextPath();

		//copy jar principal
		File temp1=File.createTempFile("signaturacaib.test.jar", "jar");
		temp1.deleteOnExit();
		URL url1=new URL(base+"/signaturacaib.test.jar.jar");
		InputStream in1=url1.openStream();
		OutputStream out1=new BufferedOutputStream(new FileOutputStream(temp1));
		copyInputStream(in1, out1);
		in1.close();
		out1.close();
		
		//copy dependencies
		File temp2=File.createTempFile("signaturacaib.core-api", "jar");
		temp2.deleteOnExit();
		URL url2=new URL(base+"/signaturacaib.core-api.jar");
		InputStream in2=url2.openStream();
		OutputStream out2=new BufferedOutputStream(new FileOutputStream(temp2));
		copyInputStream(in2, out2);
		in2.close();
		out2.close();
		
		
		File temp3=File.createTempFile("signaturacaib.test.privileged.jar", "jar");
		temp3.deleteOnExit();
		URL url3=new URL(base+"/signaturacaib.test.privileged.jar.jar");
		InputStream in3=url3.openStream();
		OutputStream out3=new BufferedOutputStream(new FileOutputStream(temp3));
		copyInputStream(in3, out3);
		in3.close();
		out3.close();
		

		/**File temp4=File.createTempFile("itext", "jar");
		temp4.deleteOnExit();
		URL url4=new URL(base+"/itext.jar");
		InputStream in4=url4.openStream();
		OutputStream out4=new BufferedOutputStream(new FileOutputStream(temp4));
		copyInputStream(in4, out4);
		in4.close();
		out4.close();**/

		File temp5=File.createTempFile("bcmail-jdk15", "jar");
		temp5.deleteOnExit();
		URL url5=new URL(base+"/bcmail-jdk15.jar");
		InputStream in5=url5.openStream();
		OutputStream out5=new BufferedOutputStream(new FileOutputStream(temp5));
		copyInputStream(in5, out5);
		in5.close();
		out5.close();

		File temp6=File.createTempFile("bcprov-jdk15", "jar");
		temp6.deleteOnExit();
		URL url6=new URL(base+"/bcprov-jdk15.jar");
		InputStream in6=url6.openStream();
		OutputStream out6=new BufferedOutputStream(new FileOutputStream(temp6));
		copyInputStream(in6, out6);
		in6.close();
		out6.close();

		File temp7=File.createTempFile("bctsp-jdk15", "jar");
		temp7.deleteOnExit();
		URL url7=new URL(base+"/bctsp-jdk15.jar");
		InputStream in7=url7.openStream();
		OutputStream out7=new BufferedOutputStream(new FileOutputStream(temp7));
		copyInputStream(in7, out7);
		in7.close();
		out7.close();

		/**
		File temp=File.createTempFile("signaturacaib.test.jar", "jar");
		temp.deleteOnExit();
		URL url=new URL(base+"/signaturacaib.test.jar.jar");
		InputStream in=url.openStream();
		OutputStream out=new BufferedOutputStream(new FileOutputStream(temp));
		copyInputStream(in, out);
		in.close();
		out.close();
		**/
		String os=System.getProperty("os.name").toLowerCase();
		
		StringBuffer classpath=new StringBuffer();
		classpath.append(temp1.getAbsolutePath());
		classpath.append((os.contains(("windows")))?";":":");
		classpath.append(temp2.getAbsolutePath());
		classpath.append((os.contains(("windows")))?";":":");
		classpath.append(temp3.getAbsolutePath());
		classpath.append((os.contains(("windows")))?";":":");
		/**classpath.append(temp4.getAbsolutePath());
		classpath.append((os.contains(("windows")))?";":":");	**/
		classpath.append(temp5.getAbsolutePath());
		classpath.append((os.contains(("windows")))?";":":");
		classpath.append(temp6.getAbsolutePath());
		classpath.append((os.contains(("windows")))?";":":");
		classpath.append(temp7.getAbsolutePath());
		
		ProcessHelper h=new ProcessHelper();
		h.setOut(response.getOutputStream());
		h.setErr(response.getOutputStream());
		h.runAndWait(new String[] {"java","-version"});
		h.runAndWait(
				new String[] {
				(request.getParameter("javahome")==null)?"java":request.getParameter("javahome")+"/bin/java"
				,"-Djava.class.path="+classpath.toString()
				,"es.caib.signatura.test.views.TestStandaloneApp"
				,"Standalone"
				,request.getParameter("config")
				,request.getParameter("export")}		
		);
		response.getOutputStream().close();
	}
	

	private void copyInputStream(InputStream inputStream,OutputStream outputStream) throws IOException {
		
		BufferedInputStream in = new BufferedInputStream (inputStream);
        byte [] b = new byte [8192];
        
        int read=0;
        while ((read = in.read(b)) > 0)
        {
        	outputStream.write(b,0,read);
        }

    }
	
}
