/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.util.Hashtable;

public class ContentTypeRegistry {
    private final String configFile = "mimes.csv";
    private Hashtable extensionsTable = new Hashtable();
    private Hashtable contentTypesTable = new Hashtable();

    public ContentTypeRegistry() throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("mimes.csv");
            StreamTokenizer st = new StreamTokenizer(is);
            st.resetSyntax();
            st.wordChars(33, 255);
            st.whitespaceChars(0, 32);
            st.eolIsSignificant(true);
            do {
                int i = 0;
                Object[] arr = new Object[2];
                do {
                    st.nextToken();
                    if (i < 2) {
                        arr[i] = st.ttype == -2 ? new Double(st.nval) : st.sval;
                        ++i;
                    }
                    if (st.ttype == 10) break;
                } while (st.ttype != -1);
                if (arr[0] != null) {
                    this.extensionsTable.put(arr[0], arr[1]);
                    this.contentTypesTable.put(arr[1], arr[0]);
                }
            } while (st.ttype != -1);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    public String getContentTypeByExtension(String extension) {
        return (String)this.extensionsTable.get(extension.toLowerCase());
    }

    public String getExtensionByContentType(String contentType) {
        return (String)this.contentTypesTable.get(contentType);
    }
}

