/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.core;

import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.core.StatusChangeEventListener;
import es.caib.signatura.test.core.SynchronizableInt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class Execution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String description = null;
    private ExecutionData data = null;
    private boolean active = true;
    private Object result = null;
    private String resultContentType = null;
    private Integer verificationResult = null;
    private SynchronizableInt status = new SynchronizableInt(0);
    private transient List statusChangeListeners = new ArrayList();
    private transient ByteArrayOutputStream outStreamBytes = new ByteArrayOutputStream();
    private transient ByteArrayOutputStream errStreamBytes = new ByteArrayOutputStream();
    private transient PrintStream outStream = new PrintStream(this.outStreamBytes);
    private transient PrintStream errStream = new PrintStream(this.outStreamBytes);
    public static final int STATUS_CREATED = 0;
    public static final int STATUS_CONFIGURED = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_DONE = 3;
    public static final int VERIFICATION_KO = 0;
    public static final int VERIFICATION_OK = 1;
    public static final int VERIFICATION_MANUAL = -1;
    public static final int VERIFICATION_REMOTE = -2;

    public Execution(String name, String Description) {
        this.name = name;
        this.description = this.description;
    }

    public abstract void execute(Map var1);

    public abstract int verify(Map var1);

    public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        ExecutionData d = new ExecutionData();
        d.parseData(executionDirector, item);
        return d;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public synchronized ExecutionData getData() {
        return this.data;
    }

    public synchronized void setData(ExecutionData data) {
        this.data = data;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized void setActive(boolean active) {
        this.active = active;
    }

    public synchronized Object getResult() {
        return this.result;
    }

    public synchronized void setResult(Object result) {
        this.result = result;
    }

    public synchronized int getStatus() {
        return this.status.get();
    }

    public synchronized List getStatusChangeListeners() {
        return this.statusChangeListeners;
    }

    public synchronized void setStatusChangeListeners(List statusChangeListeners) {
        this.statusChangeListeners = statusChangeListeners;
    }

    public void addStatusChangeEventListener(StatusChangeEventListener listener) {
        this.getStatusChangeListeners().add(listener);
    }

    protected void setStatus(int status, Map globalVariables) {
        int oldStatus = this.getStatus();
        this.status.set(status);
        Iterator it = this.getStatusChangeListeners().iterator();
        while (it.hasNext()) {
            ((StatusChangeEventListener)it.next()).executionStatusUpdated(this, globalVariables, oldStatus, status);
        }
    }

    public synchronized PrintStream getOut() {
        return this.outStream;
    }

    public synchronized PrintStream getErr() {
        return this.errStream;
    }

    public synchronized ByteArrayOutputStream getOutStreamBytes() {
        return this.outStreamBytes;
    }

    public synchronized ByteArrayOutputStream getErrStreamBytes() {
        return this.errStreamBytes;
    }

    public synchronized Integer getVerificationResult() {
        return this.verificationResult;
    }

    public synchronized void setVerificationResult(Integer verificationResult) {
        this.verificationResult = verificationResult;
    }

    public synchronized String getResultContentType() {
        return this.resultContentType;
    }

    public synchronized void setResultContentType(String resultContentType) {
        this.resultContentType = resultContentType;
    }
}

