/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.impl.signature;

import es.caib.signatura.api.Signer;
import es.caib.signatura.api.SignerFactory;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.data.SignatureExecutionData;
import es.caib.signatura.test.privileged.utils.SignatureTestUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public abstract class SignatureExecution
extends Execution {
    private static final long serialVersionUID = 1L;
    private transient Signer signer;

    public SignatureExecution(String name, String Description) {
        super(name, Description);
    }

    public final void execute(Map globalVariables) {
        try {
            String unactive = DynamicQueryResolver.resolveString(((SignatureExecutionData)this.getData()).getUnactiveProviders(), globalVariables);
            System.out.println("######################");
            System.out.println("Execution: " + this.getName());
            if (unactive != null) {
                SignatureTestUtils.setUnactiveProviders((String)unactive);
            }
            String str_properties = DynamicQueryResolver.resolveString(((SignatureExecutionData)this.getData()).getProperties(), globalVariables);
            Properties api_properties = null;
            if (str_properties != null && !"".equals(str_properties)) {
                api_properties = new Properties();
                api_properties.load(new ByteArrayInputStream(str_properties.getBytes()));
            }
            this.signer = new SignerFactory(api_properties).getSigner();
            this.executeSignature(globalVariables);
            SignatureTestUtils.setUnactiveProviders((String)"");
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.setResult(t);
        }
    }

    protected abstract void executeSignature(Map var1) throws Throwable;

    public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        SignatureExecutionData d = new SignatureExecutionData();
        d.parseData(executionDirector, item);
        return d;
    }

    public synchronized Signer getSigner() {
        return this.signer;
    }
}

