/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.impl.signature.data;

import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.data.SignatureExecutionData;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultipleSignatureExecutionData
extends SignatureExecutionData {
    private String unactiveProviders = "";
    private String fileToSignURL;
    private String[] certName = null;
    private String[] password = null;
    private String[] contentType = null;

    public void parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            this.setUnactiveProviders((String)xpath.evaluate("./unactiveproviders", item, XPathConstants.STRING));
            this.setFileToSignURL((String)xpath.evaluate("./filetosignurl", item, XPathConstants.STRING));
            NodeList signers = (NodeList)xpath.evaluate("./signer", item, XPathConstants.NODESET);
            this.certName = new String[signers.getLength()];
            this.password = new String[signers.getLength()];
            this.contentType = new String[signers.getLength()];
            for (int i = 1; i <= signers.getLength(); ++i) {
                this.parseSigners(i - 1, (Node)xpath.evaluate("./signer[" + i + "]", item, XPathConstants.NODE));
            }
        }
        catch (Throwable t) {
            throw new ExecutionDataParseException(t.getMessage(), t);
        }
    }

    private void parseSigners(int i, Node item) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.setCertName(i, (String)xpath.evaluate("./certname", item, XPathConstants.STRING));
        this.setPassword(i, (String)xpath.evaluate("./password", item, XPathConstants.STRING));
        this.setContentType(i, (String)xpath.evaluate("./contenttype", item, XPathConstants.STRING));
    }

    public synchronized String getUnactiveProviders() {
        return this.unactiveProviders;
    }

    public synchronized void setUnactiveProviders(String unactiveProviders) {
        this.unactiveProviders = unactiveProviders;
    }

    public synchronized String getCertName(int index) {
        return this.certName[index];
    }

    public synchronized void setCertName(int index, String certName) {
        this.certName[index] = certName;
    }

    public synchronized String getPassword(int index) {
        return this.password[index];
    }

    public synchronized void setPassword(int index, String password) {
        this.password[index] = password;
    }

    public synchronized String getFileToSignURL() {
        return this.fileToSignURL;
    }

    public synchronized void setFileToSignURL(String fileToSignURL) {
        this.fileToSignURL = fileToSignURL;
    }

    public synchronized String getContentType(int index) {
        return this.contentType[index];
    }

    public synchronized void setContentType(int index, String contentType) {
        this.contentType[index] = contentType;
    }

    public synchronized int getSignersLength() {
        return this.certName.length;
    }
}

