/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.impl.signature.local.smime;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.SingleSignatureExecutionData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Node;

public class SingleDettachedSmimeExecution
extends SignatureExecution {
    private static final long serialVersionUID = 1L;
    private int validSignatures;
    private int invalidSignatures;

    public SingleDettachedSmimeExecution(String name, String Description) {
        super(name, Description);
    }

    protected void executeSignature(Map globalVariables) throws Throwable {
        String inputURL = DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getFileToSignURL(), globalVariables);
        InputStream ins = new URL(inputURL).openStream();
        Signature s = this.getSigner().sign(ins, DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getCertName(), globalVariables), DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getPassword(), globalVariables), DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getContentType(), globalVariables));
        try {
            ins.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        ins = new URL(inputURL).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getSigner().generateSMIME(ins, s, (OutputStream)out);
        this.setResult(out.toByteArray());
        try {
            ins.close();
            out.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public int verify(Map globalVariables) {
        byte[] s = null;
        if (this.getResult() != null) {
            try {
                s = (byte[])this.getResult();
                this.setResult(new ByteArrayInputStream(s));
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 0;
            }
            try {
                SMIMEParser parser = this.getSigner().getSMIMEParser((InputStream)((ByteArrayInputStream)this.getResult()));
                Signature[] vs = parser.getSignatures();
                for (int i = 0; i < vs.length; ++i) {
                    ByteArrayInputStream vis = new ByteArrayInputStream((byte[])parser.getSignedObject());
                    if (vs[i].verify((InputStream)vis)) {
                        ++this.validSignatures;
                        continue;
                    }
                    ++this.invalidSignatures;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.setResult(t);
                return 0;
            }
            if (this.validSignatures == 1 && this.invalidSignatures == 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        SingleSignatureExecutionData d = new SingleSignatureExecutionData();
        d.parseData(executionDirector, item);
        return d;
    }
}

