/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.impl.signature.local.smime;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.impl.signature.SignatureExecution;
import es.caib.signatura.test.impl.signature.data.SingleSignatureExecutionData;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Node;

public class SingleEnvelopedSmimeExecution
extends SignatureExecution {
    private static final long serialVersionUID = 1L;
    private int validSignatures;
    private int invalidSignatures;

    public SingleEnvelopedSmimeExecution(String name, String Description) {
        super(name, Description);
    }

    protected void executeSignature(Map globalVariables) throws Throwable {
        String inputURL = DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getFileToSignURL(), globalVariables);
        InputStream ins = new URL(inputURL).openStream();
        Signature s = this.getSigner().sign(ins, DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getCertName(), globalVariables), DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getPassword(), globalVariables), DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getContentType(), globalVariables));
        try {
            ins.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        ins = new URL(inputURL).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getSigner().generateSMIME(ins, s, (OutputStream)out);
        this.setResult(out.toByteArray());
        try {
            ins.close();
            out.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public int verify(Map globalVariables) {
        byte[] s = null;
        if (this.getResult() != null) {
            try {
                s = (byte[])this.getResult();
                this.setResult(s);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.setResult(t);
                return 0;
            }
            try {
                String inputURL = DynamicQueryResolver.resolveString(((SingleSignatureExecutionData)this.getData()).getFileToSignURL(), globalVariables);
                InputStream ins = new URL(inputURL).openStream();
                SMIMEParser parser = this.getSigner().getSMIMEParser(ins);
            }
            catch (ClassCastException cae) {
                cae.printStackTrace();
                this.setResult(cae);
                return 1;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.setResult(t);
                return 0;
            }
            this.setResult("Not an enveloped SMIME");
            return 0;
        }
        return 0;
    }

    public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        SingleSignatureExecutionData d = new SingleSignatureExecutionData();
        d.parseData(executionDirector, item);
        return d;
    }
}

