/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.impl.signature.remote.pdf;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionDataParseException;
import es.caib.signatura.test.core.ExecutionDirector;
import es.caib.signatura.test.core.RemoteExecutionVerification;
import es.caib.signatura.test.impl.signature.data.PDFSingleSignatureExecutionData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.w3c.dom.Node;

public class GoodPDFExecutionRemoteVerifier
implements RemoteExecutionVerification {
    private static final long serialVersionUID = 1L;
    public static DERObjectIdentifier OID_TIMESTAMP_SIGNER = new DERObjectIdentifier("1.2.840.113549.1.9.16.2.14");
    public int expectedSignersLength = 1;

    public Integer verify(Execution ex, Map globalVariables) {
        try {
            if (Security.getProvider("BC") == null) {
                BouncyCastleProvider p = new BouncyCastleProvider();
                Security.addProvider((Provider)p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayInputStream documento = null;
        if (ex.getResult() != null) {
            try {
                documento = new ByteArrayInputStream((byte[])ex.getResult());
                boolean valid = this.analizar(ex, globalVariables, (PDFSingleSignatureExecutionData)ex.getData(), (byte[])ex.getResult(), this.expectedSignersLength);
                if (valid) {
                    ex.setResult((byte[])ex.getResult());
                    return new Integer(1);
                }
                if (documento != null) {
                    ex.setResult((byte[])ex.getResult());
                }
                return new Integer(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (documento != null) {
                    ex.setResult((byte[])ex.getResult());
                    return new Integer(-1);
                }
                return new Integer(0);
            }
        }
        ex.setResult((byte[])ex.getResult());
        return new Integer(0);
    }

    public boolean analizar(Execution ex, Map globalVariables, PDFSingleSignatureExecutionData data, byte[] documento, int expectedSignersLength) throws Exception {
        PdfReader pdfReader = null;
        AcroFields acroFields = null;
        pdfReader = new PdfReader((InputStream)new ByteArrayInputStream(documento));
        acroFields = pdfReader.getAcroFields();
        ArrayList signatureNames = acroFields.getSignatureNames();
        Collections.sort(signatureNames);
        if (expectedSignersLength != signatureNames.size()) {
            return false;
        }
        int i = 0;
        for (i = 0; i < signatureNames.size(); ++i) {
            String sigName = (String)signatureNames.get(i);
            try {
                if (!acroFields.verifySignature(sigName, "BC").verify()) {
                    throw new Exception("La firma '" + sigName + "' no es valida en el documento PDF");
                }
            }
            catch (SignatureException e) {
                throw new Exception("Error verificando firma '" + sigName + "' en el documento PDF");
            }
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(sigName);
            PdfObject ob = pdfDictionary.get(PdfName.CONTENTS);
            CMSSignedData signedData = new CMSSignedData(ob.getBytes());
            if (!Boolean.parseBoolean(DynamicQueryResolver.resolveString(data.getCheckPAdESBES(), globalVariables))) continue;
            if (pdfDictionary.get(PdfName.CERT) != null) {
                throw new Exception("No puede haber una entrada CERT en el diccionario para cumplir PAdES BES");
            }
            if (pdfDictionary.get(PdfName.SUBFILTER).toString().equals("ETSI.CAdES.detached")) continue;
            throw new Exception("La entrada SUBFILTER del diccionario debe contener ETSI.CAdES.detached para cumplir PAdES BES");
        }
        return true;
    }

    protected boolean verificarTimestamps(CMSSignedData cmsSignedData) throws Exception {
        CertStore certs = cmsSignedData.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signerInformationStore = cmsSignedData.getSignerInfos();
        ArrayList signers = new ArrayList(signerInformationStore.getSigners());
        Iterator it = signers.iterator();
        boolean verified = true;
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            List sellos = GoodPDFExecutionRemoteVerifier.recuperarSellosFirmanteSigner(signer);
            byte[] digest = signer.getContentDigest();
            Iterator it2 = sellos.iterator();
            while (it2.hasNext()) {
                TimeStampToken tst = (TimeStampToken)it.next();
                verified = verified && this.verifyTimestamp(tst, signer, digest);
            }
        }
        return verified;
    }

    public static List recuperarSellosFirmanteSigner(SignerInformation signer) throws Exception {
        ArrayList<TimeStampToken> sellos = new ArrayList<TimeStampToken>();
        byte[] encoded = null;
        TimeStampToken tst = null;
        CMSSignedData contentInfo = null;
        if (signer.getUnsignedAttributes() == null) {
            return sellos;
        }
        Attribute att = signer.getUnsignedAttributes().get(OID_TIMESTAMP_SIGNER);
        if (att != null) {
            ASN1Set values = att.getAttrValues();
            for (int ia = 0; ia < values.size(); ++ia) {
                DEREncodable token = values.getObjectAt(ia);
                encoded = token.getDERObject().getDEREncoded();
                contentInfo = new CMSSignedData(encoded);
                tst = new TimeStampToken(contentInfo);
                sellos.add(tst);
            }
        }
        return sellos;
    }

    protected boolean verifyTimestamp(TimeStampToken tst, SignerInformation si, byte[] documentDigest) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean timeStampVerified;
        block5: {
            timeStampVerified = false;
            try {
                Collection<? extends Certificate> certificates;
                CertStore certs;
                byte[] signatureDigest = GoodPDFExecutionRemoteVerifier.digest(si.getSignature());
                if (tst == null || (certs = tst.getCertificatesAndCRLs("Collection", "BC")) == null || (certificates = certs.getCertificates((CertSelector)tst.getSID())) == null || certificates.size() <= 0) break block5;
                X509Certificate timeStampCertificate = this.getTimeStampCertificates(certificates)[0];
                try {
                    tst.validate(timeStampCertificate, "BC");
                    timeStampVerified = true;
                    TimeStampTokenInfo tsTokenInfo = tst.getTimeStampInfo();
                    byte[] hashTimeStamp = tsTokenInfo.getMessageImprintDigest();
                    timeStampVerified = timeStampVerified && hashTimeStamp.length == signatureDigest.length;
                    for (int i = 0; i < signatureDigest.length && timeStampVerified; ++i) {
                        timeStampVerified = timeStampVerified && hashTimeStamp[i] == signatureDigest[i];
                    }
                }
                catch (Exception e) {
                    throw new SignatureVerifyException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new SignatureVerifyException((Throwable)e);
            }
        }
        return timeStampVerified;
    }

    public static byte[] digest(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest digester = MessageDigest.getInstance("SHA-1", "BC");
        digester.update(data);
        return digester.digest();
    }

    public X509Certificate[] getTimeStampCertificates(Collection certCollection) throws Exception {
        Iterator certIt = certCollection.iterator();
        Vector v = new Vector();
        while (certIt.hasNext()) {
            v.add(certIt.next());
        }
        return v.toArray(new X509Certificate[v.size()]);
    }

    public ExecutionData parseData(ExecutionDirector executionDirector, Node item) throws ExecutionDataParseException {
        PDFSingleSignatureExecutionData d = new PDFSingleSignatureExecutionData();
        d.parseData(executionDirector, item);
        return d;
    }
}

