/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.tradise;

import com.tradise.crypto.CryptoServiceProvider;
import com.tradise.crypto.certificate.CertificateStoreService;
import com.tradise.crypto.certificate.data.PrivateKeyCertificateChain;
import com.tradise.crypto.exception.AuthorizationException;
import com.tradise.crypto.exception.CommunicationException;
import com.tradise.crypto.exception.ServiceNotAvailableException;
import com.tradise.crypto.signature.SignatureService;
import com.tradise.crypto.signature.data.SignedData;
import com.tradise.crypto.signature.timestamp.TimestampService;
import com.tradise.crypto.signature.timestamp.data.TimestampResponder;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignaturePrivKeyException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureSignException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.impl.MIMEInputStream;
import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignatureProviderInterface;
import es.caib.signatura.impl.SignerProviderInterface;
import es.caib.signatura.impl.ValidadorProxy;
import es.caib.signatura.provider.impl.common.PDFSigner;
import es.caib.signatura.provider.impl.common.ParsedCertificateImpl;
import es.caib.signatura.provider.impl.tradise.TradiseSignatureImpl;
import es.caib.signatura.provider.impl.tradise.TradiseSignatureRawImpl;
import es.caib.signatura.provider.tradise.TradiseSignature;
import es.caib.signatura.provider.tradise.TradiseSignatureRaw;
import es.caib.signatura.provider.tradise.TradiseSignatureRawTest;
import es.caib.signatura.provider.tradise.TradiseSignatureTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.bouncycastle.util.encoders.Base64;

public class TradiseSigner
implements SignerProviderInterface {
    private static final String TIMESTAMP_SERVICE = "Timestamp Service";
    protected static final String RECOGNIZED_CERTIFICATE_OID = "1.3.6.1.4.1.18332.40";
    protected static final String SIGNATURE_BUILDER = "CAIB";
    protected static final String SIGNATURE_APP = "SIGNATURE-API";
    protected static final String SIGNATURE_FORMAT = "CMS";
    protected static final String EXPECTED_API_VERSION = "2.5";
    private String storeFile = null;
    private String storePassword = null;
    boolean production;

    public TradiseSigner() {
        try {
            this.storeFile = System.getProperty("tradise.store.file");
            if (SigDebug.isActive()) {
                SigDebug.write((String)("TradiseSigner: El repositori del servidor es: " + this.storeFile));
            }
            this.storePassword = System.getProperty("tradise.store.password");
        }
        catch (Exception e) {
            // empty catch block
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("Service.properties");
        if (inputStream == null) {
            throw new RuntimeException("No te instal\u00b7lat l'API de signatura");
        }
        Properties tempProperties = new Properties();
        try {
            tempProperties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String version = (String)tempProperties.get("TradiseApiVersion");
        if (SigDebug.isActive()) {
            SigDebug.write((String)("TradiseSigner: Versi\u00f3 de l'API de tradise instal.lada al client: " + version));
        }
        if (version == null) {
            throw new RuntimeException("No te instal\u00b7lada la versi\u00f3 2.5 o superior de l'API de signatura");
        }
        String[] split = version.split("\\.");
        String[] split2 = EXPECTED_API_VERSION.split("\\.");
        for (int i = 0; i < split2.length; ++i) {
            int v2;
            if (i >= split.length) {
                throw new RuntimeException("No te instal\u00b7lada la versi\u00f3 2.5 o superior de l'API de signatura");
            }
            int v1 = Integer.parseInt(split[i]);
            if (v1 > (v2 = Integer.parseInt(split[i]))) {
                if (!SigDebug.isActive()) break;
                SigDebug.write((String)"TradiseSigner: Versi\u00f3 superior.");
                break;
            }
            if (v1 >= v2 || !SigDebug.isActive()) continue;
            SigDebug.write((String)("TradiseSigner: Versi\u00f3 inferior." + v1 + " < " + v2));
        }
        this.production = tempProperties.getProperty("TradiseTest") == null;
    }

    public String[] getCertList(boolean recognized) throws SignatureCertNotFoundException, SignaturePrivKeyException {
        CertificateStoreService certStoreService;
        if (SigDebug.isActive()) {
            SigDebug.write((String)"TradiseSigner: getCertList entrat");
        }
        try {
            certStoreService = this.getCertificateStore();
        }
        catch (SignatureCertNotFoundException e1) {
            throw new SignatureCertNotFoundException((Exception)((Object)e1));
        }
        catch (UnrecoverableKeyException e1) {
            throw new SignatureCertNotFoundException((Exception)e1);
        }
        catch (IOException e1) {
            throw new SignatureCertNotFoundException((Exception)e1);
        }
        PrivateKeyCertificateChain[] privateCertChains = null;
        privateCertChains = certStoreService.getPrivateKeyCertificateChains();
        Vector<String> vCertList = new Vector<String>(privateCertChains.length);
        ValidadorProxy validador = new ValidadorProxy();
        for (int i = 0; i < privateCertChains.length; ++i) {
            PrivateKeyCertificateChain privCertChain = privateCertChains[i];
            try {
                privCertChain.getMainCertificate().checkValidity();
                ParsedCertificateImpl parser = new ParsedCertificateImpl(privCertChain.getMainCertificateChain(), true);
                if (SigDebug.isActive()) {
                    SigDebug.write((String)("TradiseSigner: getCertList certificat trobat " + parser.getCommonName()));
                }
                if ((!this.production || parser.isTest()) && (this.production || !parser.isTest()) || (!recognized || !parser.isRecognized()) && (recognized || !parser.isAdvanced())) continue;
                if (validador.isEnDesenvolupament()) {
                    vCertList.addElement(parser.getCommonName());
                    if (!SigDebug.isActive()) continue;
                    SigDebug.write((String)("TradiseSigner: getCertList certificat afegit " + parser.getCommonName()));
                    continue;
                }
                if (parser.isTest()) continue;
                vCertList.addElement(parser.getCommonName());
                if (!SigDebug.isActive()) continue;
                SigDebug.write((String)("TradiseSigner: getCertList certificat afegit " + parser.getCommonName()));
                continue;
            }
            catch (CertificateException e) {
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)"TradiseSigner: getCertList retornant");
        }
        return vCertList.toArray(new String[vCertList.size()]);
    }

    private CertificateStoreService getCertificateStore() throws SignatureCertNotFoundException, UnrecoverableKeyException, IOException {
        try {
            return (CertificateStoreService)AccessController.doPrivileged(new GetCertificateStoreAction());
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof SignatureCertNotFoundException) {
                throw (SignatureCertNotFoundException)((Object)e2);
            }
            if (e2 instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)e2;
            }
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e);
        }
    }

    private CertificateStoreService[] detectCertificateStores() throws SignatureCertNotFoundException {
        CertificateStoreService[] certStores = null;
        try {
            certStores = CryptoServiceProvider.detectCertificateStores();
        }
        catch (ExceptionInInitializerError initError) {
            throw new SignatureCertNotFoundException();
        }
        return certStores;
    }

    public Signature sign(InputStream contentStream, String certificateName, String password, String contentType, boolean recognized, boolean timestamp, boolean signRaw) throws IOException, SignatureException {
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)("TradiseSigner: sign cert " + certificateName + ", recognized " + (recognized ? "Si" : "No") + ", timestamp " + (timestamp ? "Si" : "No")));
        }
        Signature signature = null;
        PrivateKeyCertificateChain privKeyCertChain = this.getPrivateKeyCertificateChain(certificateName, recognized);
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)"TradiseSigner: sign firmant");
        }
        if (timestamp) {
            try {
                signature = this.signTimestamped(contentStream, privKeyCertChain, password, contentType, signRaw);
            }
            catch (Exception e) {
                throw new SignatureException(e.getMessage(), e.getCause());
            }
        } else {
            signature = this.signAdvanced(contentStream, privKeyCertChain, password, contentType, signRaw);
        }
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)"TradiseSigner: sign retornant");
        }
        return signature;
    }

    public void signPDF(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, boolean recognized, String url, int position) throws IOException, SignatureException {
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)("TradiseSigner: sign cert " + certificateName + ", recognized " + (recognized ? "Si" : "No")));
        }
        PrivateKeyCertificateChain privKeyCertChain = this.getPrivateKeyCertificateChain(certificateName, recognized);
        try {
            PDFSigner.sign((InputStream)contentStream, (OutputStream)signedStream, (PrivateKey)privKeyCertChain.getPrivateKey(password), (X509Certificate[])privKeyCertChain.getMainCertificateChain(), (String)url, (int)position);
        }
        catch (UnrecoverableKeyException e) {
            throw new SignatureException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage(), e.getCause());
        }
    }

    private Signature signAdvanced(InputStream contentStream, PrivateKeyCertificateChain privKeyCertChain, String password, String contentType, boolean signRaw) throws IOException, SignatureDataException, SignatureProviderException, SignatureSignException {
        SignatureService signatureService;
        Signature signatureData = null;
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)"TradiseSigner: signAdvanced entrant");
        }
        try {
            signatureService = CryptoServiceProvider.getSignatureService((String)SIGNATURE_BUILDER, (String)SIGNATURE_APP);
        }
        catch (ServiceNotAvailableException e) {
            throw new SignatureProviderException((Throwable)e);
        }
        if (signatureService == null) {
            throw new SignatureProviderException();
        }
        SignedData signedData = null;
        if (signRaw) {
            signedData = signatureService.initSignedData(contentStream, null, SIGNATURE_FORMAT);
        } else {
            MIMEInputStream mime = new MIMEInputStream(contentStream, contentType);
            signedData = signatureService.initSignedData((InputStream)mime, null, SIGNATURE_FORMAT);
        }
        try {
            signedData.addSimpleSignature(privKeyCertChain, password.toCharArray());
        }
        catch (UnrecoverableKeyException e1) {
            if (SigDebug.isVerbose()) {
                SigDebug.write((String)"TradiseSigner: signAdvanced UnrecoverableKeyException");
            }
            throw new SignatureSignException("Contrassenya incorrecta", (Throwable)e1);
        }
        signatureData = this.getSignatureData(this.production, signRaw, signedData, contentType);
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)"TradiseSigner: signAdvanced retornant");
        }
        byte[] arr = signatureData.getPkcs7();
        return signatureData;
    }

    private Signature getSignatureData(boolean parmProduction, boolean signRaw, SignedData signedData, String contentType) throws SignatureDataException {
        if (parmProduction) {
            if (signRaw) {
                return new TradiseSignatureRaw((SignatureProviderInterface)new TradiseSignatureRawImpl(signedData, contentType));
            }
            return new TradiseSignature((SignatureProviderInterface)new TradiseSignatureImpl(signedData, contentType));
        }
        if (signRaw) {
            return new TradiseSignatureRawTest((SignatureProviderInterface)new TradiseSignatureRawImpl(signedData, contentType));
        }
        return new TradiseSignatureTest((SignatureProviderInterface)new TradiseSignatureImpl(signedData, contentType));
    }

    private PrivateKeyCertificateChain getPrivateKeyCertificateChain(String certificateCommonName, boolean recognizedCertificate) throws SignatureProviderException, SignatureCertNotFoundException, SignaturePrivKeyException {
        CertificateStoreService certStoreService;
        try {
            certStoreService = this.getCertificateStore();
        }
        catch (UnrecoverableKeyException e) {
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (IOException e) {
            throw new SignatureCertNotFoundException((Exception)e);
        }
        PrivateKeyCertificateChain[] privateCertChains = null;
        privateCertChains = certStoreService.getPrivateKeyCertificateChains();
        boolean certificateFound = false;
        PrivateKeyCertificateChain privCertChain = null;
        for (int i = 0; i < privateCertChains.length && !certificateFound; ++i) {
            privCertChain = privateCertChains[i];
            try {
                X509Certificate[] certs = privCertChain.getMainCertificateChain();
                certs[0].checkValidity();
                ParsedCertificateImpl parser = new ParsedCertificateImpl(certs, true);
                if (!parser.getCommonName().equals(certificateCommonName) || (!this.production || parser.isTest()) && (this.production || !parser.isTest()) || (!recognizedCertificate || !parser.isRecognized()) && (recognizedCertificate || !parser.isAdvanced())) continue;
                certificateFound = true;
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (CertificateException e) {
                // empty catch block
            }
        }
        if (!certificateFound) {
            if (SigDebug.isActive()) {
                SigDebug.write((String)"TradiseSigner: Certificat no trobat.");
            }
            throw new SignatureCertNotFoundException();
        }
        return privCertChain;
    }

    private Signature signTimestamped(InputStream contentStream, PrivateKeyCertificateChain privKeyCertChain, String password, String contentType, boolean signRaw) throws IOException, SignatureDataException, SignatureSignException, SignatureTimestampException, SignatureProviderException {
        TimestampResponder[] tsResponders;
        TimestampService tsService;
        SignatureService signatureService;
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)"TradiseSigner: signTimestamped entrant");
        }
        Signature signatureData = null;
        try {
            signatureService = CryptoServiceProvider.getSignatureService((String)SIGNATURE_BUILDER, (String)SIGNATURE_APP);
            tsService = this.getTimestampService(privKeyCertChain);
        }
        catch (ServiceNotAvailableException e3) {
            throw new SignatureProviderException((Throwable)e3);
        }
        if (signatureService == null) {
            throw new SignatureProviderException();
        }
        SignedData signedData = null;
        signedData = signRaw ? signatureService.initSignedData(contentStream, null, SIGNATURE_FORMAT) : signatureService.initSignedData((InputStream)new MIMEInputStream(contentStream, contentType), null, SIGNATURE_FORMAT);
        try {
            tsResponders = tsService.getResponders();
        }
        catch (CommunicationException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
        if (tsResponders.length == 0) {
            throw new SignatureTimestampException("No responders found.");
        }
        SignatureTimestampException lastException = null;
        boolean ok = false;
        int j = new Random().nextInt(tsResponders.length);
        for (int i = 0; !ok && tsResponders != null && i < tsResponders.length; ++i) {
            try {
                int index = (i + j) % tsResponders.length;
                tsResponders[index].connect(privKeyCertChain, password.toCharArray());
                signedData.addLongTermSignature(privKeyCertChain, password.toCharArray(), tsResponders[index]);
                ok = true;
                continue;
            }
            catch (UnrecoverableKeyException e1) {
                if (SigDebug.isVerbose()) {
                    SigDebug.write((String)"TradiseSigner: signTimestamped UnrecoverableKeyException");
                }
                throw new SignatureSignException("TradiseSigner: signTimestamped UnrecoverableKeyException", (Throwable)e1);
            }
            catch (Exception e) {
                lastException = new SignatureTimestampException((Throwable)e);
            }
        }
        if (!ok) {
            if (SigDebug.isVerbose()) {
                SigDebug.write((String)"TradiseSigner: signTimestamped ! ok");
            }
            if (lastException != null) {
                throw lastException;
            }
            throw new SignatureProviderException("No hi ha cap proveidor de segells de temps");
        }
        signatureData = this.getSignatureData(this.production, signRaw, signedData, contentType);
        contentStream.close();
        if (SigDebug.isVerbose()) {
            SigDebug.write((String)"TradiseSigner: signTimestamped retornant");
        }
        return signatureData;
    }

    public void generateSMIME(InputStream document, Signature signature, OutputStream smime) throws IOException {
        int n;
        String smimeText = new String("");
        smimeText = smimeText + "Content-Type: multipart/signed; protocol=\"application/pkcs7-signature\"; micalg=\"sha1\"; ";
        smimeText = smimeText + "boundary=\"govern-de-les-illes-balears-boundary\"\r\n\r\n";
        smimeText = smimeText + "--govern-de-les-illes-balears-boundary\r\n";
        smime.write(smimeText.getBytes("UTF-8"));
        MIMEInputStream mime = new MIMEInputStream(document, signature.getContentType());
        byte[] byteBuffer = new byte[256];
        while ((n = mime.read(byteBuffer)) != -1) {
            smime.write(byteBuffer, 0, n);
        }
        smimeText = "\r\n--govern-de-les-illes-balears-boundary\r\n";
        smimeText = smimeText + "Content-Type: application/pkcs7-signature; name=\"smime.p7s\" smime-type=signed-data\r\n";
        smimeText = smimeText + "Content-Transfer-Encoding: base64\r\n";
        smimeText = smimeText + "Content-Disposition: attachment; filename=\"smime.p7s\"\r\n";
        smimeText = smimeText + "Content-Description: S/MIME Cryptographic Signature\r\n\r\n";
        smime.write(smimeText.getBytes("UTF-8"));
        byte[] p7Base64 = Base64.encode((byte[])signature.getPkcs7());
        StringReader reader = new StringReader(new String(p7Base64, "UTF-8"));
        StringBuffer text = new StringBuffer();
        n = 0;
        char[] buffer = new char[64];
        while ((n = reader.read(buffer, 0, 64)) > -1) {
            text.append(buffer, 0, n);
            text.append("\r\n");
        }
        text.append("\r\n--govern-de-les-illes-balears-boundary--\r\n");
        smime.write(text.toString().getBytes("UTF-8"));
        smime.flush();
        smime.close();
        document.close();
    }

    public Date getCurrentDate(String certificateName, String password, boolean recognized) throws SignatureException, IOException {
        try {
            PrivateKeyCertificateChain privateKeyCertificateChain = this.getPrivateKeyCertificateChain(certificateName, recognized);
            TimestampService tsService = this.getTimestampService(privateKeyCertificateChain);
            TimestampResponder[] enotarios = tsService.getResponders();
            TimestampResponder enotary = enotarios[0];
            enotary.connect(privateKeyCertificateChain, password.toCharArray());
            return new Date(enotary.getServerTime().getTime());
        }
        catch (ServiceNotAvailableException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
        catch (CommunicationException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
    }

    private TimestampService getTimestampService(PrivateKeyCertificateChain key) throws ServiceNotAvailableException, SignatureProviderException {
        return CryptoServiceProvider.getTimestampService((String)SIGNATURE_BUILDER, (String)TIMESTAMP_SERVICE);
    }

    public String getVersion() {
        return "3.0.0";
    }

    private class GetCertificateStoreAction
    implements PrivilegedExceptionAction {
        private GetCertificateStoreAction() {
        }

        public Object run() throws Exception {
            CertificateStoreService certStoreService;
            if (TradiseSigner.this.storeFile != null && TradiseSigner.this.storePassword != null) {
                certStoreService = CryptoServiceProvider.getCertificateStoreService((String)TradiseSigner.this.storePassword, (String)TradiseSigner.this.storeFile);
            } else {
                CertificateStoreService[] certStores = TradiseSigner.this.detectCertificateStores();
                if (certStores == null || certStores.length == 0) {
                    if (SigDebug.isActive()) {
                        SigDebug.write((String)("TradiseSigner: Error, cerStores=" + certStores + " i longitud=" + certStores.length));
                    }
                    throw new SignatureCertNotFoundException();
                }
                certStoreService = certStores[0];
            }
            return certStoreService;
        }
    }
}

