/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.tradise;

import com.tradise.crypto.CryptoServiceProvider;
import com.tradise.crypto.certificate.util.CertificateUtil;
import com.tradise.crypto.exception.BadFormatException;
import com.tradise.crypto.exception.ServiceNotAvailableException;
import com.tradise.crypto.signature.SignatureService;
import com.tradise.crypto.signature.data.SignatureCertificateChain;
import com.tradise.crypto.signature.data.SignedData;
import com.tradise.crypto.signature.timestamp.data.TimestampTokenCertificateChain;
import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.MIMEInputStream;
import es.caib.signatura.impl.ParsedCertificateProxy;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.impl.SignatureProviderInterface;
import es.caib.signatura.provider.impl.common.ParsedCertificateImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class TradiseSignatureImpl
implements SignatureProviderInterface {
    private SignedData signedData;
    private X509Certificate[] certificateChain;
    private String contentType;
    private byte[] signatureBytes;
    protected static final String SIGNATURE_BUILDER = "CAIB";

    protected TradiseSignatureImpl(SignedData signedData, String contentType) throws SignatureDataException {
        ByteArrayOutputStream signatureByteArray = new ByteArrayOutputStream();
        try {
            this.getSignatureService().saveSignatures(signedData, (OutputStream)signatureByteArray);
        }
        catch (IOException e) {
            throw new SignatureDataException((Throwable)e);
        }
        this.signedData = signedData;
        this.signatureBytes = signatureByteArray.toByteArray();
        this.contentType = contentType;
        this.extractCertificate();
    }

    public TradiseSignatureImpl() {
    }

    public X509Certificate[] getCertificateChain() throws Exception {
        return this.certificateChain;
    }

    public void setSignedData(byte[] pkcs7) throws Exception {
        try {
            this.signatureBytes = pkcs7;
            ByteArrayInputStream voidContentData = new ByteArrayInputStream(new byte[0]);
            this.signedData = this.getSignatureService().readSignedData((InputStream)voidContentData, null, (InputStream)new ByteArrayInputStream(pkcs7), "CMS");
            voidContentData.close();
        }
        catch (BadFormatException e) {
            throw new IOException("Unable to parse signed data");
        }
        this.extractCertificate();
    }

    public String getCertCaName() {
        return this.certificateChain[this.certificateChain.length - 1].getSubjectX500Principal().getName();
    }

    public String getCertSubjectCommonName() {
        return CertificateUtil.getSubjectCommonName((X509Certificate)this.certificateChain[0]);
    }

    public String getCertSubjectAlternativeNames() {
        StringBuffer altNameSB = new StringBuffer("");
        String altNameString = null;
        try {
            Collection<List<?>> generalNames = this.certificateChain[0].getSubjectAlternativeNames();
            Iterator<List<?>> itr = generalNames.iterator();
            while (itr.hasNext()) {
                List<?> list = itr.next();
                int tagNo = (Integer)list.get(0);
                switch (tagNo) {
                    case 0: {
                        altNameSB.append(",otherName=");
                        break;
                    }
                    case 1: {
                        altNameSB.append(",rfc822Name=");
                        break;
                    }
                    case 2: {
                        altNameSB.append(",dNSName=");
                        break;
                    }
                    case 3: {
                        altNameSB.append(",x400Address=");
                        break;
                    }
                    case 4: {
                        altNameSB.append(",directoryName=");
                        break;
                    }
                    case 5: {
                        altNameSB.append(",ediPartyName=");
                        break;
                    }
                    case 6: {
                        altNameSB.append(",uniformResourceIdentifier=");
                        break;
                    }
                    case 7: {
                        altNameSB.append(",iPAddress=");
                        break;
                    }
                    case 8: {
                        altNameSB.append(",registeredID=");
                    }
                }
                altNameSB.append(list.get(1).toString());
                if (altNameSB.length() <= 0) continue;
                altNameString = altNameSB.substring(1, altNameSB.length());
            }
        }
        catch (Exception ex) {
            return null;
        }
        return altNameString;
    }

    private void extractCertificate() {
        SignatureCertificateChain[] chain = this.signedData.getSignatures();
        if (chain.length != 1) {
            throw new RuntimeException("Unable to find signer");
        }
        this.certificateChain = chain[0].getMainCertificateChain();
    }

    private SignatureService getSignatureService() {
        try {
            return CryptoServiceProvider.getSignatureService((String)SIGNATURE_BUILDER, (String)"SIGNATURE-API");
        }
        catch (ServiceNotAvailableException e3) {
            throw new RuntimeException(e3);
        }
    }

    public byte[] getPkcs7() {
        try {
            return this.signatureBytes;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getDate() throws SignatureTimestampException {
        SignatureCertificateChain[] chain = this.signedData.getSignatures();
        if (chain.length != 1) {
            throw new RuntimeException("Unable to find signer");
        }
        this.certificateChain = chain[0].getMainCertificateChain();
        Date timeStamp = null;
        SignatureService signatureService = this.getSignatureService();
        try {
            SignatureCertificateChain[] signatures = this.signedData.getSignatures();
            for (int i = 0; i < signatures.length; ++i) {
                SignatureCertificateChain currentSignature = signatures[i];
                TimestampTokenCertificateChain[] tst = currentSignature.getTimestampTokenAttributes();
                if (tst == null || tst.length <= 0) continue;
                timeStamp = tst[0].getTimestamp();
            }
        }
        catch (Exception ex) {
            throw new SignatureTimestampException((Throwable)ex);
        }
        return timeStamp;
    }

    public boolean verify() {
        try {
            this.certificateChain[0].checkValidity();
        }
        catch (CertificateExpiredException cee) {
            return false;
        }
        catch (CertificateNotYetValidException cve) {
            return false;
        }
        return true;
    }

    public X509Certificate getCert() {
        SignatureCertificateChain[] chain = this.signedData.getSignatures();
        if (chain.length != 1) {
            throw new RuntimeException("Unable to find signer");
        }
        return chain[0].getMainCertificate();
    }

    public boolean verifyAPosterioriTimestamp(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        MIMEInputStream mimeContentStream = new MIMEInputStream(contentStream, this.getContentType());
        return this.verifyAPosterioriTimestampRaw((InputStream)mimeContentStream);
    }

    protected boolean verifyAPosterioriTimestampRaw(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        SignatureService signatureService;
        boolean result = true;
        SignatureCertificateChain[] signaturesCertChain = null;
        try {
            signatureService = CryptoServiceProvider.getSignatureService((String)SIGNATURE_BUILDER, (String)"SIGNATURE-API");
        }
        catch (ServiceNotAvailableException e) {
            throw new SignatureProviderException((Throwable)e);
        }
        if (signatureService == null) {
            throw new SignatureProviderException();
        }
        ByteArrayInputStream signatureStream = null;
        if (this.signatureBytes == null) {
            return false;
        }
        signatureStream = new ByteArrayInputStream(this.signatureBytes);
        try {
            SignedData localSignedData = signatureService.readSignedData(contentStream, null, (InputStream)signatureStream, "CMS");
            signaturesCertChain = localSignedData.getSignatures();
        }
        catch (BadFormatException bfe) {
            throw new SignatureVerifyException(bfe.getCause());
        }
        for (int i = 0; i < signaturesCertChain.length; ++i) {
            boolean bl = result = result && signaturesCertChain[i].verify();
            if (!result) continue;
            TimestampTokenCertificateChain[] timestampCertificateChain = signaturesCertChain[i].getTimestampTokenAttributes();
            if (timestampCertificateChain == null || timestampCertificateChain.length == 0) {
                SignaturaProperties signaturaProperties = new SignaturaProperties();
                if (!signaturaProperties.needsTimeStamp(this.contentType)) continue;
                return false;
            }
            for (int j = 0; j < timestampCertificateChain.length; ++j) {
                boolean bl2 = result = result && timestampCertificateChain[j].verify();
                if (j != 0) continue;
                result = result && timestampCertificateChain[i].checkTimestampedData(signaturesCertChain[i].getSignature());
            }
        }
        return result;
    }

    public boolean verify(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        MIMEInputStream mimeContentStream = new MIMEInputStream(contentStream, this.getContentType());
        return this.verifyRaw((InputStream)mimeContentStream);
    }

    protected boolean verifyRaw(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        SignatureService signatureService;
        boolean result = true;
        SignatureCertificateChain[] signaturesCertChain = null;
        try {
            signatureService = CryptoServiceProvider.getSignatureService((String)SIGNATURE_BUILDER, (String)"SIGNATURE-API");
        }
        catch (ServiceNotAvailableException e) {
            throw new SignatureProviderException((Throwable)e);
        }
        if (signatureService == null) {
            throw new SignatureProviderException();
        }
        ByteArrayInputStream signatureStream = null;
        if (this.signatureBytes == null) {
            return false;
        }
        signatureStream = new ByteArrayInputStream(this.signatureBytes);
        try {
            SignedData localSignedData = signatureService.readSignedData(contentStream, null, (InputStream)signatureStream, "CMS");
            signaturesCertChain = localSignedData.getSignatures();
        }
        catch (BadFormatException bfe) {
            throw new SignatureVerifyException(bfe.getCause());
        }
        for (int i = 0; i < signaturesCertChain.length; ++i) {
            boolean bl = result = result && signaturesCertChain[i].verify();
            if (!result) continue;
            TimestampTokenCertificateChain[] timestampCertificateChain = signaturesCertChain[i].getTimestampTokenAttributes();
            if (timestampCertificateChain == null || timestampCertificateChain.length == 0) {
                SignaturaProperties signaturaProperties = new SignaturaProperties();
                if (!signaturaProperties.needsTimeStamp(this.contentType)) continue;
                return false;
            }
            for (int j = 0; j < timestampCertificateChain.length; ++j) {
                boolean bl2 = result = result && timestampCertificateChain[j].verify();
                if (j != 0) continue;
                result = result && timestampCertificateChain[i].checkTimestampedData(signaturesCertChain[i].getSignature());
            }
        }
        return result;
    }

    public void setContentType(String contentType) throws Exception {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ParsedCertificate getParsedCertificate() {
        try {
            return new ParsedCertificateProxy((ParsedCertificate)new ParsedCertificateImpl(this.certificateChain, false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

