package es.caib.signatura.provider.impl.tradise;

import java.io.IOException;
import java.io.InputStream;
import com.tradise.crypto.signature.data.SignedData;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.api.Signer;
import es.caib.signatura.impl.RawSignature;

/**
 * Implementación de la interfaz <code>SignatureProviderInterface</code> para usar con la
 * entidad certificadora Tradisea y con contenido raw.
 * 
 * @author 3dígits
 * @version 0.98
 * @see Signer
 * @see Signature
 */
public class TradiseSignatureRawImpl extends TradiseSignatureImpl implements RawSignature {

	protected TradiseSignatureRawImpl(SignedData signedData, String contentType)
			throws SignatureDataException 
	{
		super( signedData, contentType );

	}

	public TradiseSignatureRawImpl ()
	{
		super();
	}

	public boolean verifyAPosterioriTimestamp(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
		return verifyAPosterioriTimestampRaw( contentStream );
	}
	
	
	public boolean verify(InputStream contentStream)
		throws SignatureProviderException, IOException, SignatureVerifyException 
	{
		return verifyRaw( contentStream );
	}

}
