package es.caib.signatura.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import es.caib.signatura.web.ejb.SignaturaAPIPropertiesEJB;
import es.caib.signatura.web.ejb.SignaturaAPIPropertiesEJBHome;
import es.caib.signatura.web.ejb.SignaturaAPIPropertiesVO;

/**
 * Servlet implementation class adminSignaturaAPIPropertiesServlet
 * @author e43155798r
 */
public class AdminSignaturaAPIPropertiesServlet extends HttpServlet {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		doGet(request, response);
		
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		String opcion = request.getParameter("opcion");
		
		if (opcion != null && !"".equals(opcion)) {
			
			if ("listado".equals(opcion)) {
			
				listado(request, response);
				
			} else if ("precreacion".equals(opcion)) {
								
				precreacion(request, response);
				
			} else if ("creacion".equals(opcion)) {
								
				creacion(request, response);
				
			} else if ("consulta".equals(opcion)) {
								
				consulta(request, response);
				
			}
		
		} else {
			
			listado(request, response);
			
		} // end if-else opcion
		
	}
	
	private void listado(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		
		Context ctx;
		try {
			
			ctx = new InitialContext();
	
			Object obj = ctx.lookup("java:comp/env/ejb/SignaturaAPIPropertiesEJB");
			
			SignaturaAPIPropertiesEJBHome home = 
				(SignaturaAPIPropertiesEJBHome)PortableRemoteObject.narrow(obj, SignaturaAPIPropertiesEJBHome.class);
	
			SignaturaAPIPropertiesEJB sapEjb = home.create();
			ArrayList datos = sapEjb.obtenerRegistros();
			sapEjb.remove();
						
			request.setAttribute("datos", datos);
			
			RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/WEB-INF/jsp/admin/listado.jsp");
			dispatcher.forward(request, response);
			
		} catch (NamingException e) {
			
			throw new ServletException(e);
			
		} catch (RemoteException e) {

			throw new ServletException(e);
			
		} catch (CreateException e) {

			throw new ServletException(e);
			
		} catch (RemoveException e) {
			
			throw new ServletException(e);
			
		}
		
	}
		
	private void consulta(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
				
		if (request.getParameter("id") == null)
			throw new ServletException("Se esparada el valor ID para la consulta de la ficha");
		
		BigDecimal id = new BigDecimal( request.getParameter("id") );
		
		Context ctx;
		try {
			
			ctx = new InitialContext();
	
			Object obj = ctx.lookup("java:comp/env/ejb/SignaturaAPIPropertiesEJB");
			
			SignaturaAPIPropertiesEJBHome home = 
				(SignaturaAPIPropertiesEJBHome)PortableRemoteObject.narrow(obj, SignaturaAPIPropertiesEJBHome.class);
	
			SignaturaAPIPropertiesEJB sapEjb = home.create();
			SignaturaAPIPropertiesVO datos = sapEjb.obtenerRegistroPorId(id);
			sapEjb.remove();
			
			request.setAttribute("opcion", "consulta");
			request.setAttribute("datos", datos);
			
			RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/WEB-INF/jsp/admin/ficha.jsp");
			dispatcher.forward(request, response);
			
		} catch (NamingException e) {
			
			throw new ServletException(e);
			
		} catch (RemoteException e) {

			throw new ServletException(e);
			
		} catch (CreateException e) {

			throw new ServletException(e);
			
		} catch (RemoveException e) {
			
			throw new ServletException(e);
			
		}
		
	}
	
	private void precreacion(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
				
		Context ctx;
		try {
			
			ctx = new InitialContext();
	
			Object obj = ctx.lookup("java:comp/env/ejb/SignaturaAPIPropertiesEJB");
			
			SignaturaAPIPropertiesEJBHome home = 
				(SignaturaAPIPropertiesEJBHome)PortableRemoteObject.narrow(obj, SignaturaAPIPropertiesEJBHome.class);
	
			SignaturaAPIPropertiesEJB sapEjb = home.create();
			SignaturaAPIPropertiesVO datos = sapEjb.obtenerUltimoRegistro();
			
			// Quitamos la propiedad build.number, ya que se añade automáticamente
			if (datos != null) {
			
				datos.setSapTexto( datos.getSapTexto().replaceAll("build\\.number.*", "") );
				
			}
			
			request.setAttribute("opcion", "precreacion");
			request.setAttribute("datos", datos);
			
			RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/WEB-INF/jsp/admin/ficha.jsp");
			dispatcher.forward(request, response);
	
			sapEjb.remove();
			
		} catch (NamingException e) {
			
			throw new ServletException(e);
			
		} catch (RemoteException e) {

			throw new ServletException(e);
			
		} catch (CreateException e) {

			throw new ServletException(e);
			
		} catch (RemoveException e) {
			
			throw new ServletException(e);
			
		}
		
	}

	private void creacion(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		
		if (request.getParameter("texto") == null)
			throw new ServletException("Se esparada el valor TEXTO para la creación de la nueva revisión");
		
		// Pasamos el texto a UTF-8...
		String texto = request.getParameter("texto");
		String encoding = request.getCharacterEncoding();
		
		try {
		
			if (encoding == null) {
				
				// Suponemos ISO8859-1, por estándar
				texto = new String( texto.getBytes("ISO-8859-1"), "UTF-8" );
				
			} else {
				
				texto = new String( texto.getBytes(encoding), "UTF-8" );
							
			}
			
		} catch (UnsupportedEncodingException uee) {
			
			throw new ServletException(uee);
			
		}
		
		Context ctx;
		try {
			
			ctx = new InitialContext();
	
			Object obj = ctx.lookup("java:comp/env/ejb/SignaturaAPIPropertiesEJB");
			
			SignaturaAPIPropertiesEJBHome home = 
				(SignaturaAPIPropertiesEJBHome)PortableRemoteObject.narrow(obj, SignaturaAPIPropertiesEJBHome.class);
	
			SignaturaAPIPropertiesEJB sapEjb = home.create();
			
			Principal principal = request.getUserPrincipal();
			
			SignaturaAPIPropertiesVO datos = new SignaturaAPIPropertiesVO();
			datos.setSapTexto(texto);
			datos.setSapUsuCre(principal.getName());
			datos.setSapFechaCre(new Date());
			
			sapEjb.insertarRegistro(datos);
			
			sapEjb.remove();
			
			response.sendRedirect("adminSAP?opcion=listado&mensaje=creacionOK");
			
		} catch (NamingException e) {
			
			throw new ServletException(e);
			
		} catch (RemoteException e) {

			throw new ServletException(e);
			
		} catch (CreateException e) {

			throw new ServletException(e);
			
		} catch (RemoveException e) {
			
			throw new ServletException(e);
			
		}
		
	}
	
}