/**
 * 
 */
package es.caib.signatura.web.ejb;

import java.rmi.RemoteException;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;
/**
 * @author e43155798r
 *
 */
public class SignaturaAPIPropertiesCache {
	
	private static SignaturaAPIPropertiesVO properties;
	private static Logger log=Logger.getLogger(SignaturaAPIPropertiesCache.class);
	
	// Si ha pasado más de REFRESH_TIME (milisegundos), refrescaremos la caché.
	private static final long REFRESH_TIME = 3600000;
	private static Date lastUpdate = null; 

	/**
	 * @return the properties
	 * @throws Exception 
	 */
	public static synchronized SignaturaAPIPropertiesVO getProperties() throws Exception {
		checkRefreshTime();
		return properties;
	}

	private static void checkRefreshTime() throws Exception {
		
		// Actualizamos el registro con el signatura_api.properties si:
		// 1. Si el registro es nulo (inicialización en primer uso o reinicio del servidor).
		// 2. Ha pasado el tiempo máximo que se guarda en caché el registro.
		if ( (properties == null) || (new Date().getTime() - lastUpdate.getTime()) > REFRESH_TIME ) {
			
			Context ctx;
			try {
				
				ctx = new InitialContext();
		
				Object obj = ctx.lookup("java:comp/env/ejb/SignaturaAPIPropertiesEJB");
				
				SignaturaAPIPropertiesEJBHome home = 
					(SignaturaAPIPropertiesEJBHome)PortableRemoteObject.narrow(obj, SignaturaAPIPropertiesEJBHome.class);
		
				SignaturaAPIPropertiesEJB sapEjb = home.create();
				// Actualizamos caché
				properties = sapEjb.obtenerUltimoRegistro();
				// Actualizamos el último acceso
				lastUpdate = new Date();
						
				sapEjb.remove();
				
			} catch (NamingException e) {
				
				log.error(e.getMessage(), e);
				throw new Exception(e);
				
			} catch (RemoteException e) {
				
				log.error(e.getMessage(), e);
				throw new Exception(e);
				
			} catch (CreateException e) {
				
				log.error(e.getMessage(), e);
				throw new Exception(e);
				
			} catch (RemoveException e) {
				
				log.error(e.getMessage(), e);	
				throw new Exception(e);
				
			}
			
		}
		
	}
	
}
