package es.caib.signatura.web.ejb;

import javax.ejb.EJBObject;

import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;

/** 
 * EJB de acceso al archivo almacenado en base de datos signatura_api.properties
 * @author $Author: e43155798r $
 */
public interface SignaturaAPIPropertiesEJB extends EJBObject {
	
	/**
	 * @return
	 * @throws RemoteException
	 */
	public ArrayList obtenerRegistros() throws RemoteException;

	/**
	 * @param id
	 * @return
	 * @throws RemoteException
	 */
	public SignaturaAPIPropertiesVO obtenerRegistroPorId(BigDecimal id) throws RemoteException;
	
	/**
	 * @return
	 * @throws RemoteException
	 */
	public SignaturaAPIPropertiesVO obtenerUltimoRegistro() throws RemoteException;
	
	/**
	 * @param registro
	 * @throws RemoteException
	 */
	public void insertarRegistro(SignaturaAPIPropertiesVO registro) throws RemoteException;
	
	/**
	 * @param id
	 * @throws RemoteException
	 */
	public void borrarRegistro(BigDecimal id) throws RemoteException;
	
}
