package es.caib.signatura.web.ejb;

import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

import oracle.sql.CLOB;

/**
 * @author e43155798r
 *
 */
public class SignaturaAPIPropertiesEJBBean implements SessionBean {

	private static final long serialVersionUID = -1971189664077670418L;
	private static final String DATASOURCE_JNDI = "java:comp/env/es.caib.signatura.db";
	private static Logger log=Logger.getLogger(SignaturaAPIPropertiesEJBBean.class);
	
	//
    // EJB-required methods
    //
    public void ejbCreate()
    {
//        System.out.println("ejbCreate()");
    }

    public void ejbRemove()
    {
//        System.out.println("ejbRemove()");
    }

    public void ejbActivate()
    {
//        System.out.println("ejbActivate()");
    }

    public void ejbPassivate()
    {
//        System.out.println("ejbPassivate()");
    }

    public void setSessionContext(SessionContext ctx)
    {
//        System.out.println("setSessionContext()");
    }
    
    /**
     * Métodos implementados
     */

    /**
     * Obtiene todos los registros de la tabla SIG_PROPERTIESAPI
     * @return
     * @throws RemoteException
     */
    public ArrayList obtenerRegistros() throws RemoteException {
		
		Context jndi;
        DataSource ds;
        
		try {
			
			jndi = new InitialContext ();
			ds = (DataSource) PortableRemoteObject.narrow(
			jndi.lookup(DATASOURCE_JNDI), DataSource.class);
			
			Connection con = ds.getConnection();
			Statement st = con.createStatement();
			ResultSet rs = st.executeQuery("SELECT * FROM SIG_PROPERTIESAPI ORDER BY PRP_ID DESC");
			
			ArrayList list = new ArrayList();
						
			while ( rs.next() ) {
							    
			    SignaturaAPIPropertiesVO registro = new SignaturaAPIPropertiesVO(
						rs.getBigDecimal("PRP_ID"),
						rs.getString("PRP_TEXTO"),
						rs.getString("PRP_USUCRE"),
						rs.getTimestamp("PRP_FECHACRE")
				);
			    
			    list.add(registro);
		    
			}
			
			con.close();
			
			return list;
			
		} catch (ClassCastException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (NamingException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (SQLException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		}
		    
    }
    
    /**
     * Obtiene el registro de la tabla SIG_PROPERTIESAPI con el valor id en la columna PRP_ID
     * @param id
     * @return
     * @throws RemoteException
     */
    public SignaturaAPIPropertiesVO obtenerRegistroPorId(BigDecimal id) throws RemoteException {
    	    	
    	Context jndi;
        DataSource ds;
        
    	try {
			
			jndi = new InitialContext();
			ds = (DataSource)PortableRemoteObject.narrow(
			jndi.lookup(DATASOURCE_JNDI), DataSource.class);
			
			Connection con = ds.getConnection();
			Statement st = con.createStatement();
			ResultSet rs = st.executeQuery("SELECT * FROM SIG_PROPERTIESAPI WHERE PRP_ID = " + id);
			
			SignaturaAPIPropertiesVO registro = null;
			
			if ( rs.next() ) {
			    
				registro = new SignaturaAPIPropertiesVO(
						rs.getBigDecimal("PRP_ID"),
						rs.getString("PRP_TEXTO"),
						rs.getString("PRP_USUCRE"),
						rs.getTimestamp("PRP_FECHACRE")
				);
			
			}
						
			con.close();
			
			return registro;
			
		} catch (ClassCastException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (NamingException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (SQLException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		}
    	    	
    }
    
    /**
     * Obtiene el último registro introducido en la tabla SIG_PROPERTIESAPI
     * @return
     * @throws RemoteException
     */
    public SignaturaAPIPropertiesVO obtenerUltimoRegistro() throws RemoteException {
    	
    	Context jndi;
        DataSource ds;
    	
    	try {
			
			jndi = new InitialContext();
			ds = (DataSource)PortableRemoteObject.narrow(
			jndi.lookup(DATASOURCE_JNDI), DataSource.class);
			
			Connection con = ds.getConnection();
			Statement st = con.createStatement();
			ResultSet rs = st.executeQuery("SELECT * FROM SIG_PROPERTIESAPI WHERE PRP_ID = (SELECT MAX(PRP_ID) FROM SIG_PROPERTIESAPI)");
			
			SignaturaAPIPropertiesVO registro = null;
			
			if ( rs.next() ) {
			    
				registro = new SignaturaAPIPropertiesVO(
						rs.getBigDecimal("PRP_ID"),
						rs.getString("PRP_TEXTO"),
						rs.getString("PRP_USUCRE"),
						rs.getTimestamp("PRP_FECHACRE")
				);
			
			}
						
			con.close();
			
			return registro;
			
		} catch (ClassCastException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (NamingException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (SQLException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (Exception e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		}
        	    	    	
    }
    
    /**
     * Inserta un registro en la tabla SIG_PROPERTIESAPI
     * @param registro
     * @throws RemoteException
     */
    public void insertarRegistro(SignaturaAPIPropertiesVO registro) throws RemoteException {
    	
    	Context jndi;
        DataSource ds;
                
        Statement st = null, st2 = null;
        Connection con = null;
        ResultSet rs = null, rs2 = null, rs3 = null;
        PreparedStatement ps = null, ps2 = null, ps3 = null;
        
    	try {
			
			jndi = new InitialContext();
			ds = (DataSource)PortableRemoteObject.narrow(
			jndi.lookup(DATASOURCE_JNDI), DataSource.class);
			
			con = ds.getConnection();	
			
			// Obtenemos la que será la clave primaria...
			st = con.createStatement();
			rs = st.executeQuery("SELECT SIG_SEQPRP.nextval AS PK FROM dual");
			BigDecimal pk = null;
			
			if ( rs.next() )
				pk = rs.getBigDecimal("PK");
						
			if (pk == null)
				throw new RemoteException("No se pudo obtener la clave primaria (secuencia) del registro a insertar.");
						
			// Obtenemos el build number...
			st2 = con.createStatement();
			rs2 = st2.executeQuery("SELECT SIG_SEQPRPBUILD.nextval AS BN FROM dual");
			BigDecimal buildNumber = null;
			
			if ( rs2.next() )
				buildNumber = rs2.getBigDecimal("BN");
						
			if (buildNumber == null)
				throw new RemoteException("No se pudo obtener el build number (secuencia) del registro a insertar.");
			
			String buildNumberString = "\nbuild.number=" + buildNumber;
			
			// Preparamos insert...
			ps = con.prepareStatement(
				"INSERT INTO SIG_PROPERTIESAPI (PRP_ID, PRP_TEXTO, PRP_USUCRE, PRP_FECHACRE) VALUES (?, ?, ?, ?)"
			);
			
			CLOB clob = CLOB.empty_lob();
			
			// Hacemos un insert con un CLOB vacío.
			ps.setBigDecimal(1, pk);
			ps.setClob(2, clob);
			ps.setString(3, registro.getSapUsuCre());
			ps.setTimestamp(4, new Timestamp(registro.getSapFechaCre().getTime()));
			
			int affectedRows = 0;
			affectedRows = ps.executeUpdate();
			
			if (affectedRows != 1)
				throw new RemoteException("Falló la inserción del nuevo registro en la base de datos.");
			
			// Ejecutamos un select bloqueante para hacer un update y añadir el contenido del CLOB...
			ps2 = con.prepareStatement(
				"SELECT * FROM SIG_PROPERTIESAPI WHERE PRP_ID=? FOR UPDATE"
			);
			
			ps2.setBigDecimal(1, pk);
			rs3 = ps2.executeQuery();
			
			// Obtenemos el Clob como interface...
			Clob clob2 = null;
			
			if ( rs3.next() ) {
				
				clob2 = rs3.getClob("PRP_TEXTO");
				
				// Concatenamos buildNumber al final de todo...
				registro.setSapTexto( registro.getSapTexto() + buildNumberString );
				clob2.setString(1, registro.getSapTexto());
				
			}
			
			// Hacemos el update.
			ps3 = con.prepareStatement(
				"UPDATE SIG_PROPERTIESAPI SET PRP_TEXTO=? WHERE PRP_ID=?"
			);
						
			ps3.setClob(1, clob2);
			ps3.setBigDecimal(2, pk);
			
			affectedRows = ps3.executeUpdate();
			
			if (affectedRows != 1)
				throw new RemoteException("Falló la inserción del nuevo registro en la base de datos.");
									
		} catch (ClassCastException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (NamingException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (SQLException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} finally {
			
			// Liberamos recursos...
			try {
				if (rs != null)
					rs.close();
			} catch (Exception e) {
			}

			try {
				if (rs2 != null)
					rs2.close();
			} catch (Exception e) {
			}
			
			try {
				if (rs3 != null)
					rs3.close();
			} catch (Exception e) {
			}

			try {
				if (st != null)
					st.close();
			} catch (Exception e) {
			}
			
			try {
				if (st2 != null)
					st2.close();
			} catch (Exception e) {
			}

			try {
				if (ps != null)
					ps.close();
			} catch (Exception e) {
			}

			try {
				if (ps2 != null)
					ps2.close();
			} catch (Exception e) {
			}

			try {
				if (ps3 != null)
					ps3.close();
			} catch (Exception e) {
			}

			try {
				if (con != null)
					con.close();
			} catch (Exception e) {
			}

		}
    	
    }
    
    /**
     * Borra un registro de la tabla SIG_PROPERTIESAPI indicado por el valor de la columna PRP_ID
     * @param id
     * @throws RemoteException
     */
    public void borrarRegistro(BigDecimal id) throws RemoteException {
    	
    	Context jndi;
        DataSource ds;
        
    	try {
			
			jndi = new InitialContext();
			ds = (DataSource)PortableRemoteObject.narrow(
			jndi.lookup(DATASOURCE_JNDI), DataSource.class);
			
			Connection con = ds.getConnection();
			Statement st = con.createStatement();
			st.executeQuery("DELETE FROM SIG_PROPERTIESAPI WHERE PRP_ID = " + id);
			
			con.close();
						
		} catch (ClassCastException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (NamingException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		} catch (SQLException e) {
			log.error(e.getMessage(),e);
			throw new RemoteException(e.getMessage(), e.getCause());
			
		}
    	
    }
    	
}
