/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.web.ejb;

import es.caib.signatura.web.ejb.SignaturaAPIPropertiesEJB;
import es.caib.signatura.web.ejb.SignaturaAPIPropertiesEJBHome;
import es.caib.signatura.web.ejb.SignaturaAPIPropertiesVO;
import java.rmi.RemoteException;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;

public class SignaturaAPIPropertiesCache {
    private static SignaturaAPIPropertiesVO properties;
    private static Logger log;
    private static final long REFRESH_TIME = 3600000L;
    private static Date lastUpdate;

    public static synchronized SignaturaAPIPropertiesVO getProperties() throws Exception {
        SignaturaAPIPropertiesCache.checkRefreshTime();
        return properties;
    }

    private static void checkRefreshTime() throws Exception {
        if (properties == null || new Date().getTime() - lastUpdate.getTime() > 3600000L) {
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup("java:comp/env/ejb/SignaturaAPIPropertiesEJB");
                SignaturaAPIPropertiesEJBHome home = (SignaturaAPIPropertiesEJBHome)PortableRemoteObject.narrow((Object)obj, (Class)SignaturaAPIPropertiesEJBHome.class);
                SignaturaAPIPropertiesEJB sapEjb = home.create();
                properties = sapEjb.obtenerUltimoRegistro();
                lastUpdate = new Date();
                sapEjb.remove();
            }
            catch (NamingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
            catch (RemoteException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
            catch (CreateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
            catch (RemoveException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
        }
    }

    static {
        log = Logger.getLogger((Class)SignaturaAPIPropertiesCache.class);
        lastUpdate = null;
    }
}

